/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.config;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ConsumerBuilderImpl;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.com.google.common.base.Strings;

public class PulsarConsumerBuilder<T>
extends ConsumerBuilderImpl<T> {
    public PulsarConsumerBuilder(PulsarClient client, Schema<T> schema) {
        super((PulsarClientImpl)client, schema);
    }

    public CompletableFuture<Consumer<T>> subscribeAsync() {
        PulsarClientImpl client = super.getClient();
        ConsumerConfigurationData conf = super.getConf();
        Schema schema = super.getSchema();
        List interceptorList = super.getInterceptorList();
        if (conf.isRetryEnable()) {
            TopicName topicFirst = TopicName.get((String)((String)conf.getTopicNames().iterator().next()));
            String retryLetterTopic = topicFirst + "-" + conf.getSubscriptionName() + "-RETRY";
            String deadLetterTopic = topicFirst + "-" + conf.getSubscriptionName() + "-DLQ";
            DeadLetterPolicy deadLetterPolicy = conf.getDeadLetterPolicy();
            if (deadLetterPolicy == null) {
                conf.setDeadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(16).retryLetterTopic(retryLetterTopic).deadLetterTopic(deadLetterTopic).build());
            } else {
                if (Strings.isNullOrEmpty((String)deadLetterPolicy.getRetryLetterTopic())) {
                    deadLetterPolicy.setRetryLetterTopic(retryLetterTopic);
                }
                if (Strings.isNullOrEmpty((String)deadLetterPolicy.getDeadLetterTopic())) {
                    deadLetterPolicy.setDeadLetterTopic(deadLetterTopic);
                }
            }
            conf.getTopicNames().add(conf.getDeadLetterPolicy().getRetryLetterTopic());
        }
        if (interceptorList == null || interceptorList.isEmpty()) {
            return client.subscribeAsync(conf, schema, null);
        }
        return client.subscribeAsync(conf, schema, new ConsumerInterceptors(interceptorList));
    }
}

