/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.config;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigValidator;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.sink.PulsarSinkOptions;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;

@Internal
public final class PulsarSinkConfigUtils {
    public static final PulsarConfigValidator SINK_CONFIG_VALIDATOR = PulsarConfigValidator.builder().requiredOption(PulsarOptions.PULSAR_SERVICE_URL).conflictOptions(PulsarOptions.PULSAR_AUTH_PARAMS, PulsarOptions.PULSAR_AUTH_PARAM_MAP).build();

    private PulsarSinkConfigUtils() {
    }

    public static <T> ProducerBuilder<T> createProducerBuilder(PulsarClient client, Schema<T> schema, SinkConfiguration configuration) {
        ProducerBuilder builder = client.newProducer(schema);
        configuration.useOption(PulsarSinkOptions.PULSAR_PRODUCER_NAME, producerName -> String.format(producerName, UUID.randomUUID()), arg_0 -> ((ProducerBuilder)builder).producerName(arg_0));
        configuration.useOption(PulsarSinkOptions.PULSAR_SEND_TIMEOUT_MS, Math::toIntExact, ms -> builder.sendTimeout(ms.intValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_MAX_PUBLISH_DELAY_MICROS, s -> builder.batchingMaxPublishDelay(s.longValue(), TimeUnit.MICROSECONDS));
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_PARTITION_SWITCH_FREQUENCY_BY_PUBLISH_DELAY, arg_0 -> ((ProducerBuilder)builder).roundRobinRouterBatchingPartitionSwitchFrequency(arg_0));
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_MAX_MESSAGES, arg_0 -> ((ProducerBuilder)builder).batchingMaxMessages(arg_0));
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_MAX_BYTES, arg_0 -> ((ProducerBuilder)builder).batchingMaxBytes(arg_0));
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_ENABLED, arg_0 -> ((ProducerBuilder)builder).enableBatching(arg_0));
        configuration.useOption(PulsarSinkOptions.PULSAR_CHUNKING_ENABLED, arg_0 -> ((ProducerBuilder)builder).enableChunking(arg_0));
        configuration.useOption(PulsarSinkOptions.PULSAR_CHUNK_MAX_MESSAGE_SIZE, arg_0 -> ((ProducerBuilder)builder).chunkMaxMessageSize(arg_0));
        configuration.useOption(PulsarSinkOptions.PULSAR_COMPRESSION_TYPE, arg_0 -> ((ProducerBuilder)builder).compressionType(arg_0));
        configuration.useOption(PulsarSinkOptions.PULSAR_INITIAL_SEQUENCE_ID, arg_0 -> ((ProducerBuilder)builder).initialSequenceId(arg_0));
        configuration.useOption(PulsarSinkOptions.PULSAR_PRODUCER_CRYPTO_FAILURE_ACTION, arg_0 -> ((ProducerBuilder)builder).cryptoFailureAction(arg_0));
        Map<String, String> properties = configuration.getProperties(PulsarSinkOptions.PULSAR_PRODUCER_PROPERTIES);
        if (!properties.isEmpty()) {
            builder.properties(properties);
        }
        builder.blockIfQueueFull(true).messageRoutingMode(MessageRoutingMode.SinglePartition).enableMultiSchema(false).autoUpdatePartitions(false).accessMode(ProducerAccessMode.Shared).enableLazyStartPartitionedProducers(false);
        return builder;
    }
}

