/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.FunctionWithException;

@Internal
public final class PulsarSerdeUtils {
    private PulsarSerdeUtils() {
    }

    public static void serializeBytes(DataOutputStream out, byte[] bytes) throws IOException {
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static byte[] deserializeBytes(DataInputStream in) throws IOException {
        int size = in.readInt();
        byte[] bytes = new byte[size];
        in.readFully(bytes);
        return bytes;
    }

    public static void serializeObject(DataOutputStream out, Object obj) throws IOException {
        Preconditions.checkNotNull((Object)obj);
        byte[] objectBytes = InstantiationUtil.serializeObject((Object)obj);
        PulsarSerdeUtils.serializeBytes(out, objectBytes);
    }

    public static <T> T deserializeObject(DataInputStream in) throws IOException {
        byte[] objectBytes = PulsarSerdeUtils.deserializeBytes(in);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return (T)InstantiationUtil.deserializeObject((byte[])objectBytes, (ClassLoader)loader);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static <T> void serializeList(DataOutputStream out, List<T> list, BiConsumerWithException<DataOutputStream, T, IOException> serializer) throws IOException {
        out.writeInt(list.size());
        for (T t : list) {
            serializer.accept((Object)out, t);
        }
    }

    public static <T> List<T> deserializeList(DataInputStream in, FunctionWithException<DataInputStream, T, IOException> deserializer) throws IOException {
        int size = in.readInt();
        ArrayList<Object> set = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object t = deserializer.apply((Object)in);
            set.add(t);
        }
        return set;
    }

    public static <T> void serializeSet(DataOutputStream out, Set<T> set, BiConsumerWithException<DataOutputStream, T, IOException> serializer) throws IOException {
        out.writeInt(set.size());
        for (T t : set) {
            serializer.accept((Object)out, t);
        }
    }

    public static <T> Set<T> deserializeSet(DataInputStream in, FunctionWithException<DataInputStream, T, IOException> deserializer) throws IOException {
        int size = in.readInt();
        HashSet<Object> set = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object t = deserializer.apply((Object)in);
            set.add(t);
        }
        return set;
    }

    public static <K, V> void serializeMap(DataOutputStream out, Map<K, V> map, BiConsumerWithException<DataOutputStream, K, IOException> keySerializer, BiConsumerWithException<DataOutputStream, V, IOException> valueSerializer) throws IOException {
        out.writeInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keySerializer.accept((Object)out, entry.getKey());
            valueSerializer.accept((Object)out, entry.getValue());
        }
    }

    public static <K, V> Map<K, V> deserializeMap(DataInputStream in, FunctionWithException<DataInputStream, K, IOException> keyDeserializer, FunctionWithException<DataInputStream, V, IOException> valueDeserializer) throws IOException {
        int size = in.readInt();
        HashMap<Object, Object> result = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = keyDeserializer.apply((Object)in);
            Object value = valueDeserializer.apply((Object)in);
            result.put(key, value);
        }
        return result;
    }
}

