/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.schema.factories;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.AvroUtils;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaFactory;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaUtils;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class AvroSchemaFactory<T>
implements PulsarSchemaFactory<T> {
    @Override
    public SchemaType type() {
        return SchemaType.AVRO;
    }

    @Override
    public Schema<T> createSchema(SchemaInfo info) {
        Class typeClass = PulsarSchemaUtils.decodeClassInfo(info);
        SchemaDefinition definition = SchemaDefinition.builder().withPojo(typeClass).withProperties(info.getProperties()).build();
        return AvroSchema.of((SchemaDefinition)definition);
    }

    @Override
    public TypeInformation<T> createTypeInfo(SchemaInfo info) {
        try {
            Class decodeClassInfo = PulsarSchemaUtils.decodeClassInfo(info);
            return AvroUtils.getAvroUtils().createAvroTypeInfo(decodeClassInfo);
        }
        catch (Exception e) {
            return PulsarSchemaFactory.super.createTypeInfo(info);
        }
    }
}

