/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.schema;

import com.google.protobuf.Message;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchema;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Schema;

@Internal
public class PulsarSchemaTypeSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 7771153330969433085L;
    private final PulsarSchema<T> schema;

    public PulsarSchemaTypeSerializer(PulsarSchema<T> schema) {
        this.schema = schema;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<T> duplicate() {
        return this;
    }

    public T createInstance() {
        Class<T> recordClass = this.schema.getRecordClass();
        if (PulsarSchemaUtils.haveProtobuf() && PulsarSchemaUtils.isProtobufTypeClass(recordClass)) {
            try {
                Method newBuilderMethod = recordClass.getMethod("newBuilder", new Class[0]);
                Message.Builder builder = (Message.Builder)newBuilderMethod.invoke(null, new Object[0]);
                return (T)builder.build();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        return (T)InstantiationUtil.instantiate(recordClass);
    }

    public T copy(T from) {
        return from;
    }

    public T copy(T from, T reuse) {
        return from;
    }

    public int getLength() {
        return 0;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        Schema<T> pulsarSchema = this.schema.getPulsarSchema();
        byte[] bytes = pulsarSchema.encode(record);
        target.writeInt(bytes.length);
        target.write(bytes);
    }

    public T deserialize(DataInputView source) throws IOException {
        byte[] bytes;
        int readLen;
        int len = source.readInt();
        Preconditions.checkState((len == (readLen = source.read(bytes = new byte[len])) ? 1 : 0) != 0);
        Schema<T> pulsarSchema = this.schema.getPulsarSchema();
        return (T)pulsarSchema.decode(bytes);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        byte[] bytes;
        int readLen;
        int len = source.readInt();
        Preconditions.checkState((len == (readLen = source.read(bytes = new byte[len])) ? 1 : 0) != 0);
        target.writeInt(bytes.length);
        target.write(bytes);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PulsarSchemaTypeSerializer) {
            PulsarSchemaTypeSerializer that = (PulsarSchemaTypeSerializer)((Object)obj);
            return Objects.equals(this.schema, that.schema);
        }
        return false;
    }

    public int hashCode() {
        return this.schema.hashCode();
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new PulsarSchemaTypeSerializerSnapshot<T>(this.schema);
    }

    public static final class PulsarSchemaTypeSerializerSnapshot<T>
    implements TypeSerializerSnapshot<T> {
        private PulsarSchema<T> schema;

        public PulsarSchemaTypeSerializerSnapshot() {
        }

        public PulsarSchemaTypeSerializerSnapshot(PulsarSchema<T> schema) {
            this.schema = schema;
        }

        public int getCurrentVersion() {
            return 1;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            byte[] bytes = InstantiationUtil.serializeObject(this.schema);
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            int len = in.readInt();
            byte[] bytes = new byte[len];
            int readLen = in.read(bytes);
            Preconditions.checkState((readLen == len ? 1 : 0) != 0);
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                this.schema = (PulsarSchema)InstantiationUtil.deserializeObject((byte[])bytes, (ClassLoader)loader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public TypeSerializer<T> restoreSerializer() {
            return new PulsarSchemaTypeSerializer<T>(this.schema);
        }

        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

