/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.crypto;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.common.crypto.PulsarCrypto;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableSupplier;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.common.api.proto.MessageMetadata;

@PublicEvolving
public class DefaultPulsarCrypto
implements PulsarCrypto {
    private static final long serialVersionUID = 2246425411998723487L;
    private final CryptoKeyReader cryptoKeyReader;
    private final Set<String> encryptKeys;
    private final SerializableSupplier<MessageCrypto<MessageMetadata, MessageMetadata>> messageCryptoSupplier;

    DefaultPulsarCrypto(CryptoKeyReader cryptoKeyReader, Set<String> encryptKeys, SerializableSupplier<MessageCrypto<MessageMetadata, MessageMetadata>> messageCryptoSupplier) {
        this.cryptoKeyReader = cryptoKeyReader;
        this.encryptKeys = encryptKeys;
        this.messageCryptoSupplier = messageCryptoSupplier;
    }

    @Override
    public CryptoKeyReader cryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    @Override
    public Set<String> encryptKeys() {
        return this.encryptKeys;
    }

    @Override
    @Nullable
    public MessageCrypto<MessageMetadata, MessageMetadata> messageCrypto() {
        return (MessageCrypto)this.messageCryptoSupplier.get();
    }

    @PublicEvolving
    public static class DefaultPulsarCryptoBuilder {
        private CryptoKeyReader cryptoKeyReader;
        private final Set<String> encryptKeys = new HashSet<String>();
        private SerializableSupplier<MessageCrypto<MessageMetadata, MessageMetadata>> messageCryptoSupplier = (SerializableSupplier & Serializable)() -> null;

        DefaultPulsarCryptoBuilder() {
        }

        public DefaultPulsarCryptoBuilder cryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
            this.cryptoKeyReader = cryptoKeyReader;
            return this;
        }

        public DefaultPulsarCryptoBuilder addEncryptKeys(String ... keys) {
            this.encryptKeys.addAll(Arrays.asList(keys));
            return this;
        }

        public DefaultPulsarCryptoBuilder messageCrypto(SerializableSupplier<MessageCrypto<MessageMetadata, MessageMetadata>> messageCryptoSupplier) {
            this.messageCryptoSupplier = (SerializableSupplier)Preconditions.checkNotNull(messageCryptoSupplier);
            return this;
        }

        public DefaultPulsarCrypto build() {
            Preconditions.checkNotNull((Object)this.cryptoKeyReader, (String)"The CryptoKeyReader is required.");
            Preconditions.checkArgument((!this.encryptKeys.isEmpty() ? 1 : 0) != 0, (Object)"The encrypt keys is required.");
            return new DefaultPulsarCrypto(this.cryptoKeyReader, this.encryptKeys, this.messageCryptoSupplier);
        }
    }
}

