/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.config;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.ObjIntConsumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.connector.pulsar.common.config.PulsarConfiguration;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;

@Internal
public final class PulsarClientFactory {
    private PulsarClientFactory() {
    }

    public static PulsarClient createClient(PulsarConfiguration configuration) throws PulsarClientException {
        ClientBuilder builder = PulsarClient.builder();
        Integer requestTimeoutMs = (Integer)configuration.get(PulsarOptions.PULSAR_REQUEST_TIMEOUT_MS);
        builder.loadConf(Collections.singletonMap("requestTimeoutMs", requestTimeoutMs));
        builder.authentication(PulsarClientFactory.createAuthentication(configuration));
        configuration.useOption(PulsarOptions.PULSAR_SERVICE_URL, arg_0 -> ((ClientBuilder)builder).serviceUrl(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_LISTENER_NAME, arg_0 -> ((ClientBuilder)builder).listenerName(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_OPERATION_TIMEOUT_MS, timeout -> builder.operationTimeout(timeout.intValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_LOOKUP_TIMEOUT_MS, timeout -> builder.lookupTimeout(timeout.intValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_NUM_IO_THREADS, arg_0 -> ((ClientBuilder)builder).ioThreads(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_NUM_LISTENER_THREADS, arg_0 -> ((ClientBuilder)builder).listenerThreads(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_CONNECTIONS_PER_BROKER, arg_0 -> ((ClientBuilder)builder).connectionsPerBroker(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_CONNECTION_MAX_IDLE_SECONDS, arg_0 -> ((ClientBuilder)builder).connectionMaxIdleSeconds(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_USE_TCP_NO_DELAY, arg_0 -> ((ClientBuilder)builder).enableTcpNoDelay(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_KEY_FILE_PATH, arg_0 -> ((ClientBuilder)builder).tlsKeyFilePath(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_CERTIFICATE_FILE_PATH, arg_0 -> ((ClientBuilder)builder).tlsCertificateFilePath(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_CERTS_FILE_PATH, arg_0 -> ((ClientBuilder)builder).tlsTrustCertsFilePath(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_ALLOW_INSECURE_CONNECTION, arg_0 -> ((ClientBuilder)builder).allowTlsInsecureConnection(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_HOSTNAME_VERIFICATION_ENABLE, arg_0 -> ((ClientBuilder)builder).enableTlsHostnameVerification(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_USE_KEY_STORE_TLS, arg_0 -> ((ClientBuilder)builder).useKeyStoreTls(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_SSL_PROVIDER, arg_0 -> ((ClientBuilder)builder).sslProvider(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_KEY_STORE_TYPE, arg_0 -> ((ClientBuilder)builder).tlsKeyStoreType(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_KEY_STORE_PATH, arg_0 -> ((ClientBuilder)builder).tlsKeyStorePath(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_KEY_STORE_PASSWORD, arg_0 -> ((ClientBuilder)builder).tlsKeyStorePassword(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_TYPE, arg_0 -> ((ClientBuilder)builder).tlsTrustStoreType(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PATH, arg_0 -> ((ClientBuilder)builder).tlsTrustStorePath(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PASSWORD, arg_0 -> ((ClientBuilder)builder).tlsTrustStorePassword(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_CIPHERS, TreeSet::new, arg_0 -> ((ClientBuilder)builder).tlsCiphers(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_PROTOCOLS, TreeSet::new, arg_0 -> ((ClientBuilder)builder).tlsProtocols(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_MEMORY_LIMIT_BYTES, bytes -> builder.memoryLimit(bytes.longValue(), SizeUnit.BYTES));
        configuration.useOption(PulsarOptions.PULSAR_STATS_INTERVAL_SECONDS, v -> builder.statsInterval(v.longValue(), TimeUnit.SECONDS));
        configuration.useOption(PulsarOptions.PULSAR_CONCURRENT_LOOKUP_REQUEST, arg_0 -> ((ClientBuilder)builder).maxConcurrentLookupRequests(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_MAX_LOOKUP_REQUEST, arg_0 -> ((ClientBuilder)builder).maxLookupRequests(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_MAX_LOOKUP_REDIRECTS, arg_0 -> ((ClientBuilder)builder).maxLookupRedirects(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_MAX_NUMBER_OF_REJECTED_REQUEST_PER_CONNECTION, arg_0 -> ((ClientBuilder)builder).maxNumberOfRejectedRequestPerConnection(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_KEEP_ALIVE_INTERVAL_SECONDS, v -> builder.keepAliveInterval(v.intValue(), TimeUnit.SECONDS));
        configuration.useOption(PulsarOptions.PULSAR_CONNECTION_TIMEOUT_MS, v -> builder.connectionTimeout(v.intValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_INITIAL_BACKOFF_INTERVAL_NANOS, v -> builder.startingBackoffInterval(v.longValue(), TimeUnit.NANOSECONDS));
        configuration.useOption(PulsarOptions.PULSAR_MAX_BACKOFF_INTERVAL_NANOS, v -> builder.maxBackoffInterval(v.longValue(), TimeUnit.NANOSECONDS));
        configuration.useOption(PulsarOptions.PULSAR_ENABLE_BUSY_WAIT, arg_0 -> ((ClientBuilder)builder).enableBusyWait(arg_0));
        if (configuration.contains(PulsarOptions.PULSAR_PROXY_SERVICE_URL)) {
            String proxyServiceUrl = (String)configuration.get(PulsarOptions.PULSAR_PROXY_SERVICE_URL);
            ProxyProtocol proxyProtocol = (ProxyProtocol)configuration.get(PulsarOptions.PULSAR_PROXY_PROTOCOL);
            builder.proxyServiceUrl(proxyServiceUrl, proxyProtocol);
        }
        configuration.useOption(PulsarOptions.PULSAR_ENABLE_TRANSACTION, arg_0 -> ((ClientBuilder)builder).enableTransaction(arg_0));
        PulsarClientFactory.bindAddress(configuration, PulsarOptions.PULSAR_DNS_LOOKUP_BIND_ADDRESS, true, (arg_0, arg_1) -> ((ClientBuilder)builder).dnsLookupBind(arg_0, arg_1));
        PulsarClientFactory.bindAddress(configuration, PulsarOptions.PULSAR_SOCKS5_PROXY_ADDRESS, false, (host, port) -> {
            builder.socks5ProxyAddress(new InetSocketAddress((String)host, port));
            configuration.useOption(PulsarOptions.PULSAR_SOCKS5_PROXY_USERNAME, arg_0 -> ((ClientBuilder)builder).socks5ProxyUsername(arg_0));
            configuration.useOption(PulsarOptions.PULSAR_SOCKS5_PROXY_PASSWORD, arg_0 -> ((ClientBuilder)builder).socks5ProxyPassword(arg_0));
        });
        return builder.build();
    }

    private static Authentication createAuthentication(PulsarConfiguration configuration) throws PulsarClientException {
        if (configuration.contains(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME)) {
            String authPluginClassName = (String)configuration.get(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME);
            if (configuration.contains(PulsarOptions.PULSAR_AUTH_PARAMS)) {
                String authParamsString = (String)configuration.get(PulsarOptions.PULSAR_AUTH_PARAMS);
                return AuthenticationFactory.create((String)authPluginClassName, (String)authParamsString);
            }
            Map<String, String> paramsMap = configuration.getProperties(PulsarOptions.PULSAR_AUTH_PARAM_MAP);
            if (paramsMap.isEmpty()) {
                throw new IllegalArgumentException(String.format("No %s or %s provided", PulsarOptions.PULSAR_AUTH_PARAMS.key(), PulsarOptions.PULSAR_AUTH_PARAM_MAP.key()));
            }
            return AuthenticationFactory.create((String)authPluginClassName, paramsMap);
        }
        return AuthenticationDisabled.INSTANCE;
    }

    private static void bindAddress(PulsarConfiguration configuration, ConfigOption<String> option, boolean allowRandomPort, ObjIntConsumer<String> setter) {
        if (!configuration.contains(option)) {
            return;
        }
        String address = (String)configuration.get(option);
        if (address.contains(":")) {
            try {
                String[] addresses = address.split(":");
                String host = addresses[0];
                int port = Integer.parseInt(addresses[1]);
                setter.accept(host, port);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid address '" + address + "', port should be int.");
            }
        } else if (allowRandomPort) {
            setter.accept(address, 0);
        } else {
            throw new IllegalArgumentException("The address '" + address + "' should be in host:port format.");
        }
    }
}

