/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.source.writer;

import java.util.List;
import java.util.Set;
import org.apache.flink.connector.pulsar.common.crypto.PulsarCrypto;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.testframe.external.ExternalSystemSplitDataWriter;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ProducerBuilderImpl;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;

public class PulsarEncryptDataWriter<T>
implements ExternalSystemSplitDataWriter<T> {
    private final Producer<T> producer;

    public PulsarEncryptDataWriter(PulsarRuntimeOperator operator, String fullTopicName, Schema<T> schema, PulsarCrypto pulsarCrypto) {
        ProducerBuilder builder = operator.client().newProducer(schema).topic(fullTopicName).enableBatching(false).enableMultiSchema(true).accessMode(ProducerAccessMode.Shared).cryptoFailureAction(ProducerCryptoFailureAction.FAIL).cryptoKeyReader(pulsarCrypto.cryptoKeyReader());
        Set encryptKeys = pulsarCrypto.encryptKeys();
        encryptKeys.forEach(arg_0 -> ((ProducerBuilder)builder).addEncryptionKey(arg_0));
        MessageCrypto messageCrypto = pulsarCrypto.messageCrypto();
        if (messageCrypto != null) {
            ProducerConfigurationData conf = ((ProducerBuilderImpl)builder).getConf();
            conf.setMessageCrypto(messageCrypto);
        }
        try {
            this.producer = builder.create();
        }
        catch (PulsarClientException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void writeRecords(List<T> records) {
        try {
            for (T record : records) {
                this.producer.newMessage().value(record).send();
            }
            this.producer.flush();
        }
        catch (PulsarClientException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void close() throws Exception {
        this.producer.close();
    }
}

