/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.source.writer;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.testframe.external.ExternalSystemSplitDataWriter;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.pulsar.client.api.Schema;

public class KeyedPulsarPartitionDataWriter
implements ExternalSystemSplitDataWriter<String> {
    private final PulsarRuntimeOperator operator;
    private final String fullTopicName;
    private final String keyToRead;
    private final String keyToExclude;

    public KeyedPulsarPartitionDataWriter(PulsarRuntimeOperator operator, String fullTopicName, String keyToRead, String keyToExclude) {
        this.operator = operator;
        this.fullTopicName = fullTopicName;
        this.keyToRead = keyToRead;
        this.keyToExclude = keyToExclude;
    }

    public void writeRecords(List<String> records) {
        try {
            List newRecords = records.stream().map(a -> a + this.keyToRead).collect(Collectors.toList());
            this.operator.sendMessages(this.fullTopicName, Schema.STRING, this.keyToExclude, newRecords);
            this.operator.sendMessages(this.fullTopicName, Schema.STRING, this.keyToRead, records);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void close() {
    }
}

