/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.source.cases;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.connector.pulsar.source.PulsarSourceBuilder;
import org.apache.flink.connector.pulsar.source.PulsarSourceOptions;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.FixedKeysRangeGenerator;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.TopicRangeUtils;
import org.apache.flink.connector.pulsar.testutils.PulsarTestEnvironment;
import org.apache.flink.connector.pulsar.testutils.source.cases.MultipleTopicsConsumingContext;
import org.apache.flink.connector.pulsar.testutils.source.writer.KeyedPulsarPartitionDataWriter;
import org.apache.flink.connector.testframe.external.ExternalSystemSplitDataWriter;
import org.apache.flink.connector.testframe.external.source.TestingSourceSettings;

public class PartialKeysConsumingContext
extends MultipleTopicsConsumingContext {
    private final String keyToRead = RandomStringUtils.randomAlphabetic((int)8);
    private final String keyToExclude;

    public PartialKeysConsumingContext(PulsarTestEnvironment environment) {
        super(environment);
        String randomKey;
        int readHash = TopicRangeUtils.keyHash((String)this.keyToRead);
        while (TopicRangeUtils.keyHash((String)(randomKey = RandomStringUtils.randomAlphabetic((int)8))) == readHash) {
        }
        this.keyToExclude = randomKey;
    }

    @Override
    public ExternalSystemSplitDataWriter<String> createSourceSplitDataWriter(TestingSourceSettings sourceSettings) {
        String partitionName = this.generatePartitionName();
        return new KeyedPulsarPartitionDataWriter(this.operator, partitionName, this.keyToRead, this.keyToExclude);
    }

    @Override
    protected String displayName() {
        return "consume message by Key_Shared";
    }

    @Override
    protected void setSourceBuilder(PulsarSourceBuilder<String> builder) {
        FixedKeysRangeGenerator generator = FixedKeysRangeGenerator.builder().key(this.keyToRead).build();
        builder.setRangeGenerator((RangeGenerator)generator);
        builder.setConfig(PulsarSourceOptions.PULSAR_ALLOW_KEY_SHARED_OUT_OF_ORDER_DELIVERY, (Object)true);
    }

    @Override
    protected String subscriptionName() {
        return "pulsar-key-shared-subscription";
    }
}

