/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.source.cases;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.testutils.PulsarTestEnvironment;
import org.apache.flink.connector.pulsar.testutils.source.PulsarSourceTestContext;
import org.apache.flink.util.FlinkRuntimeException;

public class MultipleTopicsConsumingContext
extends PulsarSourceTestContext {
    private final String topicPrefix = "public/default/flink-multiple-topic-" + RandomStringUtils.randomAlphabetic((int)8) + "-";
    private int index = 0;

    public MultipleTopicsConsumingContext(PulsarTestEnvironment environment) {
        super(environment);
    }

    @Override
    protected String displayName() {
        return "consume message on multiple topic";
    }

    @Override
    protected String topicPattern() {
        return this.topicPrefix + "\\d+";
    }

    @Override
    protected String subscriptionName() {
        return "flink-multiple-topic-test";
    }

    @Override
    protected String generatePartitionName() {
        String topic = this.topicPrefix + this.index;
        try {
            this.operator.createTopic(topic, 1);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
        ++this.index;
        return TopicNameUtils.topicNameWithPartition((String)topic, (int)0);
    }
}

