/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.source.cases;

import org.apache.flink.connector.pulsar.common.crypto.DefaultPulsarCrypto;
import org.apache.flink.connector.pulsar.common.crypto.PulsarCrypto;
import org.apache.flink.connector.pulsar.source.PulsarSourceBuilder;
import org.apache.flink.connector.pulsar.testutils.PulsarTestEnvironment;
import org.apache.flink.connector.pulsar.testutils.PulsarTestKeyReader;
import org.apache.flink.connector.pulsar.testutils.source.cases.MultipleTopicsConsumingContext;
import org.apache.flink.connector.pulsar.testutils.source.writer.PulsarEncryptDataWriter;
import org.apache.flink.connector.testframe.external.ExternalSystemSplitDataWriter;
import org.apache.flink.connector.testframe.external.source.TestingSourceSettings;
import org.apache.flink.util.function.SerializableSupplier;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;

public class EncryptedMessagesConsumingContext
extends MultipleTopicsConsumingContext {
    public EncryptedMessagesConsumingContext(PulsarTestEnvironment environment) {
        super(environment);
    }

    @Override
    protected void setSourceBuilder(PulsarSourceBuilder<String> builder) {
        super.setSourceBuilder(builder);
        DefaultPulsarCrypto pulsarCrypto = PulsarCrypto.builder().cryptoKeyReader((CryptoKeyReader)new PulsarTestKeyReader()).addEncryptKeys(new String[]{"flink"}).messageCrypto((SerializableSupplier)new PulsarTestKeyReader.MessageCryptoBcSupplier(false)).build();
        builder.setPulsarCrypto((PulsarCrypto)pulsarCrypto, ConsumerCryptoFailureAction.FAIL);
    }

    @Override
    public ExternalSystemSplitDataWriter<String> createSourceSplitDataWriter(TestingSourceSettings sourceSettings) {
        String partitionName = this.generatePartitionName();
        DefaultPulsarCrypto pulsarCrypto = PulsarCrypto.builder().cryptoKeyReader((CryptoKeyReader)new PulsarTestKeyReader()).addEncryptKeys(new String[]{"flink"}).messageCrypto((SerializableSupplier)new PulsarTestKeyReader.MessageCryptoBcSupplier(true)).build();
        return new PulsarEncryptDataWriter<String>(this.operator, partitionName, this.schema, (PulsarCrypto)pulsarCrypto);
    }

    @Override
    protected String displayName() {
        return "consume messages by end-to-end encryption";
    }

    @Override
    protected String subscriptionName() {
        return "pulsar-encryption-subscription";
    }
}

