/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.sink.reader;

import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.connector.pulsar.common.crypto.PulsarCrypto;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.testframe.external.ExternalSystemDataReader;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarPartitionDataReader<T>
implements ExternalSystemDataReader<T>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarPartitionDataReader.class);
    private final Consumer<T> consumer;

    public PulsarPartitionDataReader(PulsarRuntimeOperator operator, List<String> topics, Schema<T> schema) {
        this(operator, topics, schema, PulsarCrypto.disabled());
    }

    protected PulsarPartitionDataReader(PulsarRuntimeOperator operator, List<String> topics, Schema<T> schema, PulsarCrypto pulsarCrypto) {
        ConsumerBuilder builder = operator.client().newConsumer(schema).topics(topics).subscriptionName(RandomStringUtils.randomAlphanumeric((int)12)).subscriptionType(SubscriptionType.Exclusive).subscriptionMode(SubscriptionMode.Durable).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest);
        CryptoKeyReader cryptoKeyReader = pulsarCrypto.cryptoKeyReader();
        if (cryptoKeyReader != null) {
            builder.cryptoKeyReader(cryptoKeyReader);
            builder.cryptoFailureAction(ConsumerCryptoFailureAction.FAIL);
            MessageCrypto messageCrypto = pulsarCrypto.messageCrypto();
            if (messageCrypto != null) {
                builder.messageCrypto(messageCrypto);
            }
        }
        try {
            this.consumer = builder.subscribe();
        }
        catch (PulsarClientException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public List<T> poll(Duration timeout) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            int millis;
            Message message;
            while ((message = this.consumer.receive(millis = Math.toIntExact(timeout.toMillis()), TimeUnit.MILLISECONDS)) != null) {
                this.consumer.acknowledgeCumulative(message);
                results.add(message.getValue());
            }
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
        return results;
    }

    @Override
    public void close() throws PulsarClientException {
        this.consumer.close();
    }
}

