/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.sink.cases;

import java.util.List;
import org.apache.flink.connector.pulsar.common.crypto.DefaultPulsarCrypto;
import org.apache.flink.connector.pulsar.common.crypto.PulsarCrypto;
import org.apache.flink.connector.pulsar.sink.PulsarSinkBuilder;
import org.apache.flink.connector.pulsar.testutils.PulsarTestEnvironment;
import org.apache.flink.connector.pulsar.testutils.PulsarTestKeyReader;
import org.apache.flink.connector.pulsar.testutils.sink.PulsarSinkTestContext;
import org.apache.flink.connector.pulsar.testutils.sink.reader.PulsarEncryptDataReader;
import org.apache.flink.connector.pulsar.testutils.sink.reader.PulsarPartitionDataReader;
import org.apache.flink.util.function.SerializableSupplier;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.api.Schema;

public class EncryptedMessageProducingContext
extends PulsarSinkTestContext {
    public EncryptedMessageProducingContext(PulsarTestEnvironment environment) {
        super(environment);
    }

    @Override
    protected void setSinkBuilder(PulsarSinkBuilder<String> builder) {
        DefaultPulsarCrypto pulsarCrypto = PulsarCrypto.builder().cryptoKeyReader((CryptoKeyReader)new PulsarTestKeyReader()).addEncryptKeys(new String[]{"flink"}).messageCrypto((SerializableSupplier)new PulsarTestKeyReader.MessageCryptoBcSupplier(true)).build();
        builder.setPulsarCrypto((PulsarCrypto)pulsarCrypto, ProducerCryptoFailureAction.FAIL);
    }

    @Override
    protected PulsarPartitionDataReader<String> createSinkDataReader(List<String> topics) {
        DefaultPulsarCrypto pulsarCrypto = PulsarCrypto.builder().cryptoKeyReader((CryptoKeyReader)new PulsarTestKeyReader()).addEncryptKeys(new String[]{"flink"}).messageCrypto((SerializableSupplier)new PulsarTestKeyReader.MessageCryptoBcSupplier(false)).build();
        return new PulsarEncryptDataReader<String>(this.operator, topics, Schema.STRING, (PulsarCrypto)pulsarCrypto);
    }

    @Override
    protected String displayName() {
        return "write messages into one topic by end-to-end encryption";
    }
}

