/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.runtime.singleton;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntime;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.pulsar.testutils.runtime.container.PulsarContainerRuntime;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.pulsar.shade.com.google.common.util.concurrent.Uninterruptibles;

public enum PulsarSingletonRuntime implements PulsarRuntime
{
    INSTANCE{
        private final PulsarContainerRuntime container = new PulsarContainerRuntime();
        private final AtomicReference<RuntimeStatus> status = new AtomicReference<RuntimeStatus>(RuntimeStatus.STOPPED);

        @Override
        public PulsarRuntime withConfigs(Map<String, String> configs) {
            return this.container.withConfigs(configs);
        }

        @Override
        public void startUp() {
            if (this.status.compareAndSet(RuntimeStatus.STOPPED, RuntimeStatus.STARTING)) {
                try {
                    this.container.startUp();
                    this.status.set(RuntimeStatus.STARTED);
                }
                catch (Exception e) {
                    this.status.set(RuntimeStatus.FATAL);
                    throw new FlinkRuntimeException((Throwable)e);
                }
            } else {
                while (this.status.get() != RuntimeStatus.STARTED && this.status.get() != RuntimeStatus.FATAL) {
                    Uninterruptibles.sleepUninterruptibly((Duration)Duration.ofMillis(500L));
                }
                if (this.status.get() == RuntimeStatus.FATAL) {
                    throw new FlinkRuntimeException("Fall to start this singleton container. Some error occurs.");
                }
            }
        }

        @Override
        public void tearDown() {
        }

        @Override
        public PulsarRuntimeOperator operator() {
            return this.container.operator();
        }
    };


    private static enum RuntimeStatus {
        STARTED,
        STARTING,
        STOPPED,
        FATAL;

    }
}

