/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.runtime.remote;

import java.util.Map;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntime;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.util.Preconditions;

public class PulsarRemoteRuntime
implements PulsarRuntime {
    private final String serviceUrl;
    private final String adminUrl;
    private PulsarRuntimeOperator operator;

    public PulsarRemoteRuntime(String host) {
        this("pulsar://" + host + ":" + 6650, "http://" + host + ":" + 8080);
    }

    public PulsarRemoteRuntime(String serviceUrl, String adminUrl) {
        this.serviceUrl = serviceUrl;
        this.adminUrl = adminUrl;
    }

    @Override
    public PulsarRuntime withConfigs(Map<String, String> configs) {
        if (!configs.isEmpty()) {
            throw new UnsupportedOperationException("We can't change the broker configs on a running instance.");
        }
        return this;
    }

    @Override
    public void startUp() throws Exception {
        this.operator = new PulsarRuntimeOperator(this.serviceUrl, this.adminUrl);
    }

    @Override
    public void tearDown() {
    }

    @Override
    public PulsarRuntimeOperator operator() {
        return (PulsarRuntimeOperator)Preconditions.checkNotNull((Object)this.operator, (String)"You should start this pulsar runtime first.");
    }
}

