/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.runtime.container;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntime;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PulsarContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class PulsarContainerRuntime
implements PulsarRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarContainerRuntime.class);
    private static final String PULSAR_INTERNAL_HOSTNAME = "pulsar";
    private static final String PULSAR_SERVICE_URL = String.format("pulsar://%s:%d", "pulsar", 6650);
    private static final String PULSAR_ADMIN_URL = String.format("http://%s:%d", "pulsar", 8080);
    private static final String CURRENT_VERSION = "3.0.0";
    private final PulsarContainer container = new PulsarContainer(DockerImageName.parse((String)"apachepulsar/pulsar:3.0.0"));
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Map<String, String> brokerConfigs = new HashMap<String, String>();
    private boolean boundFlink = false;
    private PulsarRuntimeOperator operator;

    public PulsarContainerRuntime() {
        this.brokerConfigs.put("acknowledgmentAtBatchIndexLevelEnabled", "true");
        this.brokerConfigs.put("systemTopicEnabled", "true");
        this.brokerConfigs.put("defaultNumberOfNamespaceBundles", "1");
        this.brokerConfigs.put("allowAutoTopicCreation", "true");
        this.brokerConfigs.put("allowAutoTopicCreationType", "partitioned");
        this.brokerConfigs.put("defaultNumPartitions", "4");
        this.brokerConfigs.put("enableBrokerSideSubscriptionPatternEvaluation", "true");
        this.brokerConfigs.put("brokerDeleteInactiveTopicsEnabled", "false");
        this.brokerConfigs.put("enableNonPersistentTopics", "true");
    }

    public PulsarContainerRuntime bindWithFlinkContainer(GenericContainer<?> flinkContainer) {
        Preconditions.checkArgument((!this.started.get() ? 1 : 0) != 0, (Object)"This Pulsar container has been started, we can't bind it to a Flink container.");
        ((PulsarContainer)((PulsarContainer)this.container.withNetworkAliases(new String[]{PULSAR_INTERNAL_HOSTNAME})).dependsOn(new Startable[]{flinkContainer})).withNetwork(flinkContainer.getNetwork());
        this.boundFlink = true;
        return this;
    }

    @Override
    public PulsarRuntime withConfigs(Map<String, String> configs) {
        this.brokerConfigs.putAll(configs);
        return this;
    }

    @Override
    public void startUp() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warn("You have started the Pulsar Container. We will skip this execution.");
            return;
        }
        this.container.withTransactions();
        this.brokerConfigs.forEach((key, value) -> {
            PulsarContainer cfr_ignored_0 = (PulsarContainer)this.container.withEnv("PULSAR_PREFIX_" + key, value);
        });
        this.container.withStartupTimeout(Duration.ofMinutes(5L));
        this.container.start();
        this.container.followOutput((Consumer)new Slf4jLogConsumer(LOG, true));
        this.operator = this.boundFlink ? new PulsarRuntimeOperator(this.container.getPulsarBrokerUrl(), PULSAR_SERVICE_URL, this.container.getHttpServiceUrl(), PULSAR_ADMIN_URL) : new PulsarRuntimeOperator(this.container.getPulsarBrokerUrl(), this.container.getHttpServiceUrl());
    }

    @Override
    public void tearDown() throws Exception {
        if (this.operator != null) {
            this.operator.close();
        }
        this.container.stop();
        this.started.compareAndSet(true, false);
    }

    @Override
    public PulsarRuntimeOperator operator() {
        return (PulsarRuntimeOperator)Preconditions.checkNotNull((Object)this.operator, (String)"You should start this pulsar runtime first.");
    }
}

