/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.runtime;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.pulsar.testutils.runtime.container.PulsarContainerRuntime;
import org.apache.flink.connector.pulsar.testutils.runtime.remote.PulsarRemoteRuntime;
import org.apache.flink.connector.pulsar.testutils.runtime.singleton.PulsarSingletonRuntime;
import org.testcontainers.containers.GenericContainer;

public interface PulsarRuntime {
    public PulsarRuntime withConfigs(Map<String, String> var1);

    default public PulsarRuntime withConfig(String key, String value) {
        return this.withConfigs(Collections.singletonMap(key, value));
    }

    public void startUp() throws Exception;

    public void tearDown() throws Exception;

    public PulsarRuntimeOperator operator();

    public static PulsarRuntime remote(String host) {
        return new PulsarRemoteRuntime(host);
    }

    public static PulsarRuntime remote(String serviceUrl, String adminUrl) {
        return new PulsarRemoteRuntime(serviceUrl, adminUrl);
    }

    public static PulsarRuntime singletonContainer() {
        return PulsarSingletonRuntime.INSTANCE;
    }

    public static PulsarRuntime container() {
        return new PulsarContainerRuntime();
    }

    public static PulsarRuntime container(GenericContainer<?> flinkContainer) {
        return new PulsarContainerRuntime().bindWithFlinkContainer(flinkContainer);
    }
}

