/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils;

import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.util.function.SerializableSupplier;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.EncryptionKeyInfo;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.impl.crypto.MessageCryptoBc;
import org.apache.pulsar.common.api.proto.MessageMetadata;

public class PulsarTestKeyReader
implements CryptoKeyReader {
    private static final long serialVersionUID = -7488297938196049791L;
    public static final String ENCRYPT_KEY = "flink";
    private final byte[] publicKey = "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwZAyz0PSoggZGIoxcrYJ\nL/s9+6aAeuETFmnfT7ityhRgSBLK9MB6lyJKahmGJpEMTgYtZCb2QBlg7w8fOKb3\nZ8UPSbR3DR38cMaftfP37VADFXTW8pxRj6p84NdgeoLDsyiVijIqxpCaPuW6ne4T\nmN1PEV20zbGeWb6l52bWkp1gincc7ghhzzEB8F1Q7YBfRcA7pBRVhmW2yxXK8K/0\ndpkVWK9XQf7/b2I9tLb0OXyaOoMsOCoAqoOy1EmgQ/iF0wO52WN4pcBTshifgrLS\ndAJxGctuHvov0inYzrwxwEw+DWVbTAG8mBRiNkPnIwnewdDTZpMlxNrL+6p2aRDF\npQIDAQAB\n-----END PUBLIC KEY-----".getBytes();
    private final byte[] privateKey = "-----BEGIN RSA PRIVATE KEY-----\nMIIEpAIBAAKCAQEAwZAyz0PSoggZGIoxcrYJL/s9+6aAeuETFmnfT7ityhRgSBLK\n9MB6lyJKahmGJpEMTgYtZCb2QBlg7w8fOKb3Z8UPSbR3DR38cMaftfP37VADFXTW\n8pxRj6p84NdgeoLDsyiVijIqxpCaPuW6ne4TmN1PEV20zbGeWb6l52bWkp1gincc\n7ghhzzEB8F1Q7YBfRcA7pBRVhmW2yxXK8K/0dpkVWK9XQf7/b2I9tLb0OXyaOoMs\nOCoAqoOy1EmgQ/iF0wO52WN4pcBTshifgrLSdAJxGctuHvov0inYzrwxwEw+DWVb\nTAG8mBRiNkPnIwnewdDTZpMlxNrL+6p2aRDFpQIDAQABAoIBAQCoOCWwM4VPBDKr\nPQ6UXtfFN1g66A0ovYrVI9XLdviyctrqSErSQqVHy6lYZC5OPiivdnbkX2gLdQLl\nQAMmPRUuvff3WjtMzw6hBD2w6AJD4BGOCCj2WBwZ+1TkIsnaLuLdRRwRKmA6iVlD\n6Gsy7cFiTJN2yDVlvkOcQy/z11ALwe2KbiMg6f72K75fgRoJ1wB54d4+CnBNHOyW\nB5Oi6ahTLp5SOZJuJuXBrvqARdODdYCHKCIEM96YtUhhQG4Ll+erWTwKlz7G848U\nAc/Yq62S3muuNttBxCdlOMXjh8zcKVMTzt/Cnvc2azYy3Z93R9jppE6BIKb98ohh\nmQfE7E3RAoGBAPSs6wlka78taH/J93wNospuMXiOGqbQCYbwxpQ3228rLzx3ffyZ\n0jw2r1hpVUsmCcaavq8vXJBmq6lSPa74FgAviTYiGPpkio5PWB5aZM4KGld2TyZJ\n480rrEgBYZDQfWFAA68Kx/HXOVfUIccR624/HEXnu8llrLWGmMNARWBvAoGBAMqF\nqxUtiZQM6BzXx2U/uUowqwGUnWegUAaPaLfaOpuRCDcxToff9QLBg5xSaOOOIZk5\n3Fvl4ROnVsz64OLzAcXBGoKxJTwnojpbkw4HMKE7MqD2TWc9D7pc2T5VA650/DDC\nFQNkKg1k/bgH+HCgMnwndRrbM7w9sljjaqca0x0rAoGAQEvof9FZ1yVRnrMuS/Ux\nYEzQx0NgkZF9z24aYPzEt1P718H245hwfM5KCcu0VEksrHohvduOUYwJdDdeakpb\nTbUwM3+GXNZq6rbDC0bp0pMpFO7MId2s9U+SuGFUiD+hkxrFXQxSOqU6NnBSaAO3\ngIMpJN2epXAIkLNMFZMgKBUCgYARIpgkFZNDZIgrEJK9XVPnFBET9CgRQX4j3/Rj\nQeKdkPrZ+KEFXAyV7BufmVVok3kCRuP/HocZq5nrg/qNGTR4L+t3TVeyLERMnbzm\nffM+YQzak5xe9Mqk4QA8huLl2t4Pngw7Gjl4oqfY70u088jxukDtQcixz6KMZMl8\nVAeyuwKBgQCcbFC00vqMvB56tc96Wdz2vn0tcjyKE+QL8f6KTG/JtVAHSGhfFkmh\n+V+g3/5sr9urOm5I//+riAqbUuuP3IIeVY4UYh5YjgwJcrGRIx0PufExsDaYCl98\nGWeubd7Bk7phXjj36+Sbs3a0dD+HmDdbHAF3JXVZlT7sVUJo4UEzlg==\n-----END RSA PRIVATE KEY-----".getBytes();

    public EncryptionKeyInfo getPublicKey(String keyName, Map<String, String> metadata) {
        if (ENCRYPT_KEY.equals(keyName)) {
            return new EncryptionKeyInfo(this.copyKey(this.publicKey), metadata);
        }
        throw new IllegalArgumentException("We only support encrypt key: \"flink\"");
    }

    public EncryptionKeyInfo getPrivateKey(String keyName, Map<String, String> metadata) {
        if (ENCRYPT_KEY.equals(keyName)) {
            return new EncryptionKeyInfo(this.copyKey(this.privateKey), metadata);
        }
        throw new IllegalArgumentException("We only support encrypt key: \"flink\"");
    }

    private byte[] copyKey(byte[] key) {
        byte[] k = new byte[key.length];
        System.arraycopy(key, 0, k, 0, key.length);
        return k;
    }

    public static class MessageCryptoBcSupplier
    implements SerializableSupplier<MessageCrypto<MessageMetadata, MessageMetadata>> {
        private final boolean producer;

        public MessageCryptoBcSupplier(boolean producer) {
            this.producer = producer;
        }

        public MessageCrypto<MessageMetadata, MessageMetadata> get() {
            return new MessageCryptoBc(RandomStringUtils.randomAlphabetic((int)10), this.producer);
        }
    }
}

