/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.test.resources.ResourceTestUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.pulsar.client.api.MessageId;

public class PulsarTestCommonUtils {
    public static DeliveryGuarantee toDeliveryGuarantee(CheckpointingMode checkpointingMode) {
        if (checkpointingMode == CheckpointingMode.AT_LEAST_ONCE) {
            return DeliveryGuarantee.AT_LEAST_ONCE;
        }
        if (checkpointingMode == CheckpointingMode.EXACTLY_ONCE) {
            return DeliveryGuarantee.EXACTLY_ONCE;
        }
        throw new IllegalArgumentException("Only exactly-once and al-least-once checkpointing mode are supported.");
    }

    public static URL resourcePath(String jarName) {
        try {
            return ResourceTestUtils.getResource((String)jarName).toAbsolutePath().toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new FlinkRuntimeException("Couldn't find jar: " + jarName);
        }
    }

    public static PulsarPartitionSplit createPartitionSplit(String topic, int partitionId) {
        return PulsarTestCommonUtils.createPartitionSplit(topic, partitionId, Boundedness.CONTINUOUS_UNBOUNDED);
    }

    public static PulsarPartitionSplit createPartitionSplit(String topic, int partitionId, Boundedness boundedness) {
        return PulsarTestCommonUtils.createPartitionSplit(topic, partitionId, boundedness, MessageId.earliest);
    }

    public static PulsarPartitionSplit createPartitionSplit(String topic, int partitionId, Boundedness boundedness, MessageId latestConsumedId) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        StopCursor stopCursor = boundedness == Boundedness.BOUNDED ? StopCursor.latest() : StopCursor.never();
        return new PulsarPartitionSplit(topicPartition, stopCursor, latestConsumedId, null);
    }

    public static List<PulsarPartitionSplit> createPartitionSplits(String topicName, int numSplits, Boundedness boundedness) {
        ArrayList<PulsarPartitionSplit> splits = new ArrayList<PulsarPartitionSplit>();
        for (int i = 0; i < numSplits; ++i) {
            splits.add(PulsarTestCommonUtils.createPartitionSplit(topicName, i, boundedness));
        }
        return splits;
    }
}

