/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.testutils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.RowUtils;
import org.apache.flink.util.CloseableIterator;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class PulsarTableTestUtils {
    public static List<Row> collectRows(Table table, int expectedSize) throws Exception {
        TableResult result = table.execute();
        ArrayList<Row> collectedRows = new ArrayList<Row>();
        try (CloseableIterator iterator = result.collect();){
            while (collectedRows.size() < expectedSize && iterator.hasNext()) {
                collectedRows.add((Row)iterator.next());
            }
        }
        result.getJobClient().ifPresent(jc -> {
            try {
                jc.cancel().get(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return collectedRows;
    }

    public static void comparedWithKeyAndOrder(Map<Row, List<Row>> expectedData, List<Row> actual, int[] keyLoc) {
        HashMap<Row, LinkedList> actualData = new HashMap<Row, LinkedList>();
        for (Row row : actual) {
            Row key = Row.project((Row)row, (int[])keyLoc);
            key.setKind(RowKind.INSERT);
            actualData.computeIfAbsent(key, k -> new LinkedList()).add(row);
        }
        Assertions.assertThat(actualData).hasSameSizeAs(expectedData);
        for (Row key : expectedData.keySet()) {
            ((ListAssert)Assertions.assertThat((List)((List)actualData.get(key))).withFailMessage("\nexpected: %s\n but was: %s\n for key: %s", new Object[]{expectedData.get(key), actualData.get(key), key})).matches(rows -> RowUtils.compareRows((List)((List)expectedData.get(key)), (List)rows, (boolean)false));
        }
    }

    public static void waitingExpectedResults(String sinkName, List<String> expected, Duration timeout) throws InterruptedException, TimeoutException {
        Collections.sort(expected);
        CommonTestUtils.waitUtil(() -> {
            List actual = TestValuesTableFactory.getResults((String)sinkName);
            Collections.sort(actual);
            return expected.equals(actual);
        }, (Duration)timeout, (String)"Can not get the expected result.");
    }

    public static List<String> readLines(String resource) throws IOException {
        URL url = PulsarTableTestUtils.class.getClassLoader().getResource(resource);
        assert (url != null);
        Path path = new File(url.getFile()).toPath();
        return Files.readAllLines(path);
    }
}

