/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.source.cases;

import java.util.Collections;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.connector.pulsar.source.PulsarSourceBuilder;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.FixedRangeGenerator;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.connector.pulsar.testutils.PulsarTestEnvironment;
import org.apache.flink.connector.pulsar.testutils.source.KeyedPulsarPartitionDataWriter;
import org.apache.flink.connector.pulsar.testutils.source.cases.MultipleTopicConsumingContext;
import org.apache.flink.connector.testframe.external.ExternalSystemSplitDataWriter;
import org.apache.flink.connector.testframe.external.source.TestingSourceSettings;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.util.Murmur3_32Hash;

public class KeySharedSubscriptionContext
extends MultipleTopicConsumingContext {
    private final String keyToRead = RandomStringUtils.randomAlphabetic((int)8);
    private final String keyToExclude;

    public KeySharedSubscriptionContext(PulsarTestEnvironment environment) {
        super(environment);
        String randomKey;
        int readHash = this.keyHash(this.keyToRead);
        while (this.keyHash(randomKey = RandomStringUtils.randomAlphabetic((int)8)) == readHash) {
        }
        this.keyToExclude = randomKey;
    }

    @Override
    public ExternalSystemSplitDataWriter<String> createSourceSplitDataWriter(TestingSourceSettings sourceSettings) {
        String partitionName = this.generatePartitionName();
        return new KeyedPulsarPartitionDataWriter(this.operator, partitionName, this.keyToRead, this.keyToExclude);
    }

    @Override
    protected String displayName() {
        return "consume message by Key_Shared";
    }

    @Override
    protected void setSourceBuilder(PulsarSourceBuilder<String> builder) {
        int keyHash = this.keyHash(this.keyToRead);
        TopicRange range = new TopicRange(keyHash, keyHash);
        builder.setRangeGenerator((RangeGenerator)new FixedRangeGenerator(Collections.singletonList(range)));
    }

    @Override
    protected String subscriptionName() {
        return "pulsar-key-shared-subscription";
    }

    @Override
    protected SubscriptionType subscriptionType() {
        return SubscriptionType.Key_Shared;
    }

    private int keyHash(String key) {
        return Murmur3_32Hash.getInstance().makeHash(key.getBytes()) % 65536;
    }
}

