/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.source;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.connector.testframe.environment.TestEnvironment;
import org.apache.flink.connector.testframe.external.source.DataStreamSourceExternalContext;
import org.apache.flink.connector.testframe.testsuites.SourceTestSuiteBase;
import org.apache.flink.connector.testframe.utils.CollectIteratorAssertions;
import org.apache.flink.connector.testframe.utils.ConnectorTestConstants;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.util.CloseableIterator;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Disabled;

public abstract class UnorderedSourceTestSuiteBase<T>
extends SourceTestSuiteBase<T> {
    @Disabled(value="We don't have any idle readers in Pulsar's shared subscription.")
    public void testIdleReader(TestEnvironment testEnv, DataStreamSourceExternalContext<T> externalContext, CheckpointingMode semantic) throws Exception {
        super.testIdleReader(testEnv, externalContext, semantic);
    }

    protected void checkResultWithSemantic(CloseableIterator<T> resultIterator, List<List<T>> testData, CheckpointingMode semantic, Integer limit) {
        Runnable runnable = () -> CollectIteratorAssertions.assertUnordered((Iterator)resultIterator).withNumRecordsLimit(UnorderedSourceTestSuiteBase.getExpectedSize(testData, limit)).matchesRecordsFromSource(testData, semantic);
        AssertionsForClassTypes.assertThat(CompletableFuture.runAsync(runnable)).succeedsWithin(ConnectorTestConstants.DEFAULT_COLLECT_DATA_TIMEOUT);
    }

    private static <T> int getExpectedSize(List<List<T>> testData, Integer limit) {
        if (limit == null) {
            return testData.stream().mapToInt(List::size).sum();
        }
        return limit;
    }
}

