/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.runtime.mock;

import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.flink.connector.pulsar.testutils.runtime.mock.NonClosableMockBookKeeper;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

public class MockBookKeeperClientFactory
implements BookKeeperClientFactory {
    private final OrderedExecutor executor = OrderedExecutor.newBuilder().numThreads(1).name("mock-pulsar-bookkeeper").build();
    private final BookKeeper bookKeeper = NonClosableMockBookKeeper.create(this.executor);

    public BookKeeper create(ServiceConfiguration conf, MetadataStoreExtended store, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> ensemblePlacementPolicyProperties) throws IOException {
        return this.bookKeeper;
    }

    public BookKeeper create(ServiceConfiguration conf, MetadataStoreExtended store, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> ensemblePlacementPolicyProperties, StatsLogger statsLogger) throws IOException {
        return this.bookKeeper;
    }

    public void close() {
        try {
            this.bookKeeper.close();
            this.executor.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

