/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.extension;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.apache.flink.connector.pulsar.testutils.extension.SubType;
import org.apache.pulsar.client.api.SubscriptionType;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class TestOrderlinessExtension
implements BeforeAllCallback {
    public static final ExtensionContext.Namespace PULSAR_TEST_RESOURCE_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"pulsarTestResourceNamespace"});
    public static final String PULSAR_SOURCE_READER_SUBSCRIPTION_TYPE_STORE_KEY = "pulsarSourceReaderSubscriptionTypeStoreKey";
    private SubscriptionType subscriptionType;

    public void beforeAll(ExtensionContext context) throws Exception {
        List subscriptionTypes = AnnotationSupport.findAnnotatedFieldValues((Object)context.getRequiredTestInstance(), SubType.class, SubscriptionType.class);
        this.checkExactlyOneAnnotatedField(subscriptionTypes, SubType.class);
        this.subscriptionType = (SubscriptionType)subscriptionTypes.get(0);
        context.getStore(PULSAR_TEST_RESOURCE_NAMESPACE).put((Object)PULSAR_SOURCE_READER_SUBSCRIPTION_TYPE_STORE_KEY, (Object)this.subscriptionType);
    }

    private void checkExactlyOneAnnotatedField(Collection<?> fields, Class<? extends Annotation> annotation) {
        if (fields.size() > 1) {
            throw new IllegalStateException(String.format("Multiple fields are annotated with '@%s'", annotation.getSimpleName()));
        }
        if (fields.isEmpty()) {
            throw new IllegalStateException(String.format("No fields are annotated with '@%s'", annotation.getSimpleName()));
        }
    }
}

