/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SampleData {

    public static class FM {
        public Map<String, Bar> m;

        public FM(Map<String, Bar> m) {
            this.m = m;
        }

        public FM() {
        }

        public String toString() {
            if (this.m == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            Iterator<Map.Entry<String, Bar>> iterator = this.m.entrySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("{");
                sb.append(iterator.next());
                sb.append("}");
                ++i;
            }
            return sb.toString();
        }

        public Map<String, Bar> getM() {
            return this.m;
        }

        public void setM(Map<String, Bar> m) {
            this.m = m;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FM)) {
                return false;
            }
            FM fm = (FM)o;
            return Objects.equals(this.m, fm.m);
        }

        public int hashCode() {
            return Objects.hash(this.m);
        }
    }

    public static class FA {
        public Bar[] l;

        public FA(Bar[] l) {
            this.l = l;
        }

        public FA() {
        }

        public String toString() {
            if (this.l == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.l.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("[");
                sb.append(this.l[i]);
                sb.append("]");
            }
            return sb.toString();
        }

        public Bar[] getL() {
            return this.l;
        }

        public void setL(Bar[] l) {
            this.l = l;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FA)) {
                return false;
            }
            FA fa = (FA)o;
            return Arrays.equals(this.l, fa.l);
        }

        public int hashCode() {
            return Arrays.hashCode(this.l);
        }
    }

    public static class FL {
        public List<Bar> l;

        public FL(List<Bar> l) {
            this.l = l;
        }

        public FL() {
        }

        public String toString() {
            if (this.l == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.l.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("[");
                sb.append(this.l.get(i));
                sb.append("]");
            }
            return sb.toString();
        }

        public List<Bar> getL() {
            return this.l;
        }

        public void setL(List<Bar> l) {
            this.l = l;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FL)) {
                return false;
            }
            FL fl = (FL)o;
            return Objects.equals(this.l, fl.l);
        }

        public int hashCode() {
            return Objects.hash(this.l);
        }
    }

    public static class Bar {
        public boolean b;
        public String s;

        public Bar(boolean b, String s) {
            this.b = b;
            this.s = s;
        }

        public Bar() {
        }

        public String toString() {
            return "" + this.b + "," + this.s;
        }

        public boolean isB() {
            return this.b;
        }

        public String getS() {
            return this.s;
        }

        public void setB(boolean b) {
            this.b = b;
        }

        public void setS(String s) {
            this.s = s;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Bar)) {
                return false;
            }
            Bar bar = (Bar)o;
            return this.b == bar.b && Objects.equals(this.s, bar.s);
        }

        public int hashCode() {
            return Objects.hash(this.b, this.s);
        }
    }

    public static class Foo {
        public int i;
        public float f;
        public Bar bar;

        public Foo(int i, float f, Bar bar) {
            this.i = i;
            this.f = f;
            this.bar = bar;
        }

        public Foo() {
        }

        public String toString() {
            return "" + this.i + "," + this.f + "," + (this.bar == null ? "null" : this.bar.toString());
        }

        public int getI() {
            return this.i;
        }

        public float getF() {
            return this.f;
        }

        public Bar getBar() {
            return this.bar;
        }

        public void setI(int i) {
            this.i = i;
        }

        public void setF(float f) {
            this.f = f;
        }

        public void setBar(Bar bar) {
            this.bar = bar;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Foo)) {
                return false;
            }
            Foo foo = (Foo)o;
            return this.i == foo.i && Float.compare(foo.f, this.f) == 0 && Objects.equals(this.bar, foo.bar);
        }

        public int hashCode() {
            return Objects.hash(this.i, Float.valueOf(this.f), this.bar);
        }
    }
}

