/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils;

import java.util.ArrayList;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntime;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.testframe.TestResource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class PulsarTestEnvironment
implements BeforeAllCallback,
AfterAllCallback,
TestResource,
TestRule {
    private final PulsarRuntime runtime;

    public PulsarTestEnvironment(PulsarRuntime runtime) {
        this.runtime = runtime;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PulsarTestEnvironment.this.runtime.startUp();
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    errors.add(t);
                }
                finally {
                    try {
                        PulsarTestEnvironment.this.runtime.tearDown();
                    }
                    catch (Throwable t) {
                        errors.add(t);
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    public void beforeAll(ExtensionContext context) {
        this.runtime.startUp();
    }

    public void startUp() {
        this.runtime.startUp();
    }

    public void afterAll(ExtensionContext context) {
        this.runtime.tearDown();
    }

    public void tearDown() {
        this.runtime.tearDown();
    }

    public PulsarRuntimeOperator operator() {
        return this.runtime.operator();
    }
}

