/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.source.cases;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.testutils.PulsarTestEnvironment;
import org.apache.flink.connector.pulsar.testutils.source.PulsarSourceTestContext;
import org.apache.pulsar.client.api.SubscriptionType;

public class SingleTopicConsumingContext
extends PulsarSourceTestContext {
    private final String topicName = "pulsar-single-topic-" + RandomStringUtils.randomAlphanumeric((int)8);
    private int index = 0;

    public SingleTopicConsumingContext(PulsarTestEnvironment environment) {
        super(environment);
        this.registerTopic(this.topicName);
    }

    @Override
    protected String displayName() {
        return "consume message on single topic";
    }

    @Override
    protected String topicPattern() {
        return this.topicName + ".+";
    }

    @Override
    protected String subscriptionName() {
        return "pulsar-single-topic-test";
    }

    @Override
    protected SubscriptionType subscriptionType() {
        return SubscriptionType.Exclusive;
    }

    @Override
    protected String generatePartitionName() {
        if (this.index == 0) {
            this.operator.createTopic(this.topicName, this.index + 1);
        } else {
            this.operator.increaseTopicPartitions(this.topicName, this.index + 1);
        }
        return TopicNameUtils.topicNameWithPartition((String)this.topicName, (int)this.index++);
    }
}

