/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.sink;

import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.testframe.external.ExternalSystemDataReader;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarPartitionDataReader<T>
implements ExternalSystemDataReader<T>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarPartitionDataReader.class);
    private final Consumer<T> consumer;

    public PulsarPartitionDataReader(PulsarRuntimeOperator operator, String fullTopicName, Schema<T> schema) throws PulsarClientException {
        String subscriptionName = RandomStringUtils.randomAlphanumeric((int)12);
        this.consumer = operator.client().newConsumer(schema).topic(new String[]{fullTopicName}).subscriptionName(subscriptionName).subscriptionType(SubscriptionType.Exclusive).subscriptionMode(SubscriptionMode.Durable).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
    }

    public List<T> poll(Duration timeout) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            int millis;
            Message message;
            while ((message = this.consumer.receive(millis = Math.toIntExact(timeout.toMillis()), TimeUnit.MILLISECONDS)) != null) {
                this.consumer.acknowledgeCumulative(message);
                results.add(message.getValue());
            }
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
        return results;
    }

    @Override
    public void close() throws PulsarClientException {
        this.consumer.close();
    }
}

