/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.runtime.mock;

import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntime;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeUtils;
import org.apache.flink.connector.pulsar.testutils.runtime.mock.MockPulsarService;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.broker.ServiceConfiguration;

public class PulsarMockRuntime
implements PulsarRuntime {
    private static final String CLUSTER_NAME = "mock-pulsar-" + RandomStringUtils.randomAlphanumeric((int)6);
    private final ServiceConfiguration configuration;
    private final MockPulsarService pulsarService;
    private PulsarRuntimeOperator operator;

    public PulsarMockRuntime() {
        this(PulsarMockRuntime.createConfig());
    }

    public PulsarMockRuntime(ServiceConfiguration configuration) {
        this.configuration = configuration;
        this.pulsarService = new MockPulsarService(configuration);
    }

    @Override
    public void startUp() {
        try {
            this.pulsarService.start();
            String serviceUrl = this.pulsarService.getBrokerServiceUrl();
            String adminUrl = this.pulsarService.getWebServiceAddress();
            PulsarRuntimeUtils.initializePulsarEnvironment(this.configuration, serviceUrl, adminUrl);
            this.operator = new PulsarRuntimeOperator(serviceUrl, adminUrl);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void tearDown() {
        try {
            this.pulsarService.close();
            this.operator.close();
            this.operator = null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public PulsarRuntimeOperator operator() {
        return (PulsarRuntimeOperator)Preconditions.checkNotNull((Object)this.operator, (String)"You should start this mock pulsar first.");
    }

    private static ServiceConfiguration createConfig() {
        ServiceConfiguration configuration = new ServiceConfiguration();
        configuration.setAdvertisedAddress("localhost");
        configuration.setClusterName(CLUSTER_NAME);
        configuration.setManagedLedgerCacheSizeMB(8);
        configuration.setActiveConsumerFailoverDelayTimeMillis(0);
        configuration.setDefaultRetentionTimeInMinutes(7);
        configuration.setDefaultNumberOfNamespaceBundles(1);
        configuration.setMetadataStoreUrl("memory:local");
        configuration.setConfigurationMetadataStoreUrl("memory:local");
        configuration.setAuthenticationEnabled(false);
        configuration.setAuthorizationEnabled(false);
        configuration.setAllowAutoTopicCreation(true);
        configuration.setBrokerDeleteInactiveTopicsEnabled(false);
        configuration.setWebSocketServiceEnabled(false);
        configuration.setBrokerServicePort(Optional.of(0));
        configuration.setWebServicePort(Optional.of(0));
        configuration.setSystemTopicEnabled(true);
        configuration.setBrokerDeduplicationEnabled(true);
        configuration.setTransactionCoordinatorEnabled(true);
        configuration.setTransactionMetadataStoreProviderClassName("org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStoreProvider");
        return configuration;
    }
}

