/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.runtime.container;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntime;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PulsarContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class PulsarContainerRuntime
implements PulsarRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarContainerRuntime.class);
    private static final String PULSAR_INTERNAL_HOSTNAME = "pulsar";
    private static final String PULSAR_SERVICE_URL = String.format("pulsar://%s:%d", "pulsar", 6650);
    private static final String PULSAR_ADMIN_URL = String.format("http://%s:%d", "pulsar", 8080);
    private final PulsarContainer container = new PulsarContainer(DockerImageName.parse((String)"apachepulsar/pulsar:2.9.1"));
    private final AtomicBoolean started = new AtomicBoolean(false);
    private boolean boundFlink = false;
    private PulsarRuntimeOperator operator;

    public PulsarContainerRuntime(boolean authEnabled) {
    }

    public PulsarContainerRuntime bindWithFlinkContainer(GenericContainer<?> flinkContainer) {
        Preconditions.checkArgument((!this.started.get() ? 1 : 0) != 0, (Object)"This Pulsar container has been started, we can't bind it to a Flink container.");
        ((PulsarContainer)((PulsarContainer)this.container.withNetworkAliases(new String[]{PULSAR_INTERNAL_HOSTNAME})).dependsOn(new Startable[]{flinkContainer})).withNetwork(flinkContainer.getNetwork());
        this.boundFlink = true;
        return this;
    }

    @Override
    public void startUp() {
        boolean havenStartedBefore = this.started.compareAndSet(false, true);
        if (!havenStartedBefore) {
            LOG.warn("You have started the Pulsar Container. We will skip this execution.");
            return;
        }
        this.container.withClasspathResourceMapping("docker/bootstrap.sh", "/pulsar/bin/bootstrap.sh", BindMode.READ_ONLY);
        this.container.waitingFor(Wait.forHttp((String)"/admin/v2/namespaces/public/default").forPort(8080).forStatusCode(200).withStartupTimeout(Duration.ofMinutes(5L)));
        this.container.withCommand("sh /pulsar/bin/bootstrap.sh");
        this.container.start();
        this.container.followOutput((Consumer)new Slf4jLogConsumer(LOG).withSeparateOutputStreams());
        this.operator = this.boundFlink ? new PulsarRuntimeOperator(this.container.getPulsarBrokerUrl(), PULSAR_SERVICE_URL, this.container.getHttpServiceUrl(), PULSAR_ADMIN_URL) : new PulsarRuntimeOperator(this.container.getPulsarBrokerUrl(), this.container.getHttpServiceUrl());
    }

    @Override
    public void tearDown() {
        try {
            if (this.operator != null) {
                this.operator.close();
            }
            this.container.stop();
            this.started.compareAndSet(true, false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public PulsarRuntimeOperator operator() {
        return (PulsarRuntimeOperator)Preconditions.checkNotNull((Object)this.operator, (String)"You should start this pulsar container first.");
    }
}

