/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.runtime;

import java.util.Collections;
import java.util.List;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;

public final class PulsarRuntimeUtils {
    private PulsarRuntimeUtils() {
    }

    public static void initializePulsarEnvironment(ServiceConfiguration config, String serviceUrl, String adminUrl) throws PulsarAdminException, PulsarClientException {
        try (PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(adminUrl).build();){
            ClusterData clusterData = ClusterData.builder().serviceUrl(adminUrl).brokerServiceUrl(serviceUrl).build();
            String cluster = config.getClusterName();
            PulsarRuntimeUtils.createSampleNameSpace(admin, clusterData, cluster);
            PulsarRuntimeUtils.createNameSpace(admin, cluster, "public", "public/default");
            PulsarRuntimeUtils.createNameSpace(admin, cluster, NamespaceName.SYSTEM_NAMESPACE.getTenant(), NamespaceName.SYSTEM_NAMESPACE.toString());
            if (config.isTransactionCoordinatorEnabled() && !admin.namespaces().getTopics(NamespaceName.SYSTEM_NAMESPACE.toString()).contains(TopicName.TRANSACTION_COORDINATOR_ASSIGN.getPartition(0).toString())) {
                admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 1);
            }
        }
    }

    private static void createSampleNameSpace(PulsarAdmin admin, ClusterData clusterData, String cluster) throws PulsarAdminException {
        String tenant = "sample";
        String globalCluster = "global";
        String namespace = tenant + "/ns1";
        List clusters = admin.clusters().getClusters();
        if (!clusters.contains(cluster)) {
            admin.clusters().createCluster(cluster, clusterData);
        } else {
            admin.clusters().updateCluster(cluster, clusterData);
        }
        if (!clusters.contains(globalCluster)) {
            admin.clusters().createCluster(globalCluster, ClusterData.builder().build());
        }
        if (!admin.tenants().getTenants().contains(tenant)) {
            admin.tenants().createTenant(tenant, (TenantInfo)new TenantInfoImpl(Collections.emptySet(), Collections.singleton(cluster)));
        }
        if (!admin.namespaces().getNamespaces(tenant).contains(namespace)) {
            admin.namespaces().createNamespace(namespace);
        }
    }

    private static void createNameSpace(PulsarAdmin admin, String cluster, String publicTenant, String defaultNamespace) throws PulsarAdminException {
        if (!admin.tenants().getTenants().contains(publicTenant)) {
            admin.tenants().createTenant(publicTenant, TenantInfo.builder().adminRoles(Collections.emptySet()).allowedClusters(Collections.singleton(cluster)).build());
        }
        if (!admin.namespaces().getNamespaces(publicTenant).contains(defaultNamespace)) {
            admin.namespaces().createNamespace(defaultNamespace);
            admin.namespaces().setNamespaceReplicationClusters(defaultNamespace, Collections.singleton(cluster));
        }
    }
}

