/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils.runtime;

import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.pulsar.testutils.runtime.container.PulsarContainerRuntime;
import org.apache.flink.connector.pulsar.testutils.runtime.mock.PulsarMockRuntime;
import org.testcontainers.containers.GenericContainer;

public interface PulsarRuntime {
    public void startUp();

    public void tearDown();

    public PulsarRuntimeOperator operator();

    public static PulsarRuntime mock() {
        return new PulsarMockRuntime();
    }

    public static PulsarRuntime container() {
        return new PulsarContainerRuntime(false);
    }

    public static PulsarRuntime authContainer() {
        return new PulsarContainerRuntime(true);
    }

    public static PulsarRuntime container(GenericContainer<?> flinkContainer) {
        return new PulsarContainerRuntime(false).bindWithFlinkContainer(flinkContainer);
    }
}

