/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.testutils;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.testutils.PulsarTestEnvironment;
import org.apache.flink.connector.pulsar.testutils.runtime.PulsarRuntimeOperator;
import org.apache.flink.connector.testframe.external.ExternalContext;
import org.apache.pulsar.client.api.Schema;

public abstract class PulsarTestContext<T>
implements ExternalContext {
    private final Set<String> generateTopics = new HashSet<String>();
    protected final PulsarRuntimeOperator operator;
    protected final Schema<T> schema;

    protected PulsarTestContext(PulsarTestEnvironment environment, Schema<T> schema) {
        this.operator = environment.operator();
        this.schema = schema;
    }

    protected abstract String displayName();

    protected final void registerTopic(String topic) {
        this.generateTopics.add(TopicNameUtils.topicName((String)topic));
    }

    public String toString() {
        return this.displayName();
    }

    public List<URL> getConnectorJarPaths() {
        return Collections.emptyList();
    }

    public void close() throws Exception {
        for (String topic : this.generateTopics) {
            this.operator.deleteTopic(topic);
        }
    }
}

