/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.testutils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class PulsarTableTestUtils {
    public static List<Row> collectRows(Table table, int expectedSize) throws Exception {
        TableResult result = table.execute();
        ArrayList<Row> collectedRows = new ArrayList<Row>();
        try (CloseableIterator iterator = result.collect();){
            while (collectedRows.size() < expectedSize && iterator.hasNext()) {
                collectedRows.add((Row)iterator.next());
            }
        }
        result.getJobClient().ifPresent(jc -> {
            try {
                jc.cancel().get(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return collectedRows;
    }
}

