/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.source;

import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.util.ListCollector;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.connector.pulsar.table.source.PulsarRowDataConverter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;

public class PulsarTableDeserializationSchema
implements PulsarDeserializationSchema<RowData> {
    private static final long serialVersionUID = -3298784447432136216L;
    private final TypeInformation<RowData> producedTypeInfo;
    @Nullable
    private final DeserializationSchema<RowData> keyDeserialization;
    private final DeserializationSchema<RowData> valueDeserialization;
    private final PulsarRowDataConverter rowDataConverter;

    public PulsarTableDeserializationSchema(@Nullable DeserializationSchema<RowData> keyDeserialization, DeserializationSchema<RowData> valueDeserialization, TypeInformation<RowData> producedTypeInfo, PulsarRowDataConverter rowDataConverter) {
        this.keyDeserialization = keyDeserialization;
        this.valueDeserialization = (DeserializationSchema)Preconditions.checkNotNull(valueDeserialization);
        this.rowDataConverter = (PulsarRowDataConverter)Preconditions.checkNotNull((Object)rowDataConverter);
        this.producedTypeInfo = (TypeInformation)Preconditions.checkNotNull(producedTypeInfo);
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context, SourceConfiguration configuration) throws Exception {
        if (this.keyDeserialization != null) {
            this.keyDeserialization.open(context);
        }
        this.valueDeserialization.open(context);
    }

    @Override
    public void deserialize(Message<?> message, Collector<RowData> collector) throws IOException {
        ArrayList<RowData> valueRowData = new ArrayList<RowData>();
        this.valueDeserialization.deserialize(message.getData(), (Collector)new ListCollector(valueRowData));
        ArrayList<RowData> keyRowData = new ArrayList<RowData>();
        if (this.keyDeserialization != null) {
            this.keyDeserialization.deserialize(message.getKeyBytes(), (Collector)new ListCollector(keyRowData));
        }
        this.rowDataConverter.projectToProducedRowAndCollect(message, keyRowData, valueRowData, collector);
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    @Override
    public Schema<?> schema() {
        return Schema.BYTES;
    }
}

