/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.sink;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.pulsar.sink.PulsarSink;
import org.apache.flink.connector.pulsar.sink.PulsarSinkBuilder;
import org.apache.flink.connector.pulsar.sink.writer.delayer.FixedMessageDelayer;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRouter;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRoutingMode;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchema;
import org.apache.flink.connector.pulsar.table.sink.PulsarTableSerializationSchemaFactory;
import org.apache.flink.connector.pulsar.table.sink.PulsarWritableMetadata;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.connector.sink.abilities.SupportsWritingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

public class PulsarTableSink
implements DynamicTableSink,
SupportsWritingMetadata {
    private final PulsarTableSerializationSchemaFactory serializationSchemaFactory;
    private final ChangelogMode changelogMode;
    private final List<String> topics;
    private final Properties properties;
    private final DeliveryGuarantee deliveryGuarantee;
    @Nullable
    private final TopicRouter<RowData> topicRouter;
    private final TopicRoutingMode topicRoutingMode;
    private final long messageDelayMillis;

    public PulsarTableSink(PulsarTableSerializationSchemaFactory serializationSchemaFactory, ChangelogMode changelogMode, List<String> topics, Properties properties, DeliveryGuarantee deliveryGuarantee, @Nullable TopicRouter<RowData> topicRouter, TopicRoutingMode topicRoutingMode, long messageDelayMillis) {
        this.serializationSchemaFactory = (PulsarTableSerializationSchemaFactory)Preconditions.checkNotNull((Object)serializationSchemaFactory);
        this.changelogMode = (ChangelogMode)Preconditions.checkNotNull((Object)changelogMode);
        this.topics = (List)Preconditions.checkNotNull(topics);
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties);
        this.deliveryGuarantee = (DeliveryGuarantee)Preconditions.checkNotNull((Object)deliveryGuarantee);
        this.topicRouter = topicRouter;
        this.topicRoutingMode = (TopicRoutingMode)((Object)Preconditions.checkNotNull((Object)((Object)topicRoutingMode)));
        this.messageDelayMillis = messageDelayMillis;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return this.changelogMode;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        PulsarSerializationSchema<RowData> pulsarSerializationSchema = this.serializationSchemaFactory.createPulsarSerializationSchema(context);
        PulsarSinkBuilder<RowData> pulsarSinkBuilder = PulsarSink.builder().setSerializationSchema(pulsarSerializationSchema).setProperties(this.properties).setDeliveryGuarantee(this.deliveryGuarantee).setTopics(this.topics).setTopicRoutingMode(this.topicRoutingMode).delaySendingMessage(new FixedMessageDelayer(this.messageDelayMillis));
        if (this.topicRouter != null) {
            pulsarSinkBuilder.setTopicRouter(this.topicRouter);
        }
        return SinkV2Provider.of(pulsarSinkBuilder.build());
    }

    public String asSummaryString() {
        return "Pulsar dynamic table sink";
    }

    public Map<String, DataType> listWritableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        Stream.of(PulsarWritableMetadata.WritableMetadata.values()).forEachOrdered(m -> metadataMap.put(m.key, m.dataType));
        return metadataMap;
    }

    public void applyWritableMetadata(List<String> metadataKeys, DataType consumedDataType) {
        this.serializationSchemaFactory.setWritableMetadataKeys(metadataKeys);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarTableSink that = (PulsarTableSink)o;
        return Objects.equals(this.serializationSchemaFactory, that.serializationSchemaFactory) && Objects.equals(this.changelogMode, that.changelogMode) && Objects.equals(this.topics, that.topics) && Objects.equals(this.properties, that.properties) && this.deliveryGuarantee == that.deliveryGuarantee && Objects.equals(this.topicRouter, that.topicRouter) && this.topicRoutingMode == that.topicRoutingMode && this.messageDelayMillis == that.messageDelayMillis;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serializationSchemaFactory, this.changelogMode, this.topics, this.properties, this.deliveryGuarantee, this.topicRouter, this.topicRoutingMode, this.messageDelayMillis});
    }

    public DynamicTableSink copy() {
        PulsarTableSink copy = new PulsarTableSink(this.serializationSchemaFactory, this.changelogMode, this.topics, this.properties, this.deliveryGuarantee, this.topicRouter, this.topicRoutingMode, this.messageDelayMillis);
        return copy;
    }
}

