/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.catalog.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.connector.pulsar.common.config.PulsarClientFactory;
import org.apache.flink.connector.pulsar.table.catalog.PulsarCatalogConfiguration;
import org.apache.flink.connector.pulsar.table.catalog.impl.IncompatibleSchemaException;
import org.apache.flink.connector.pulsar.table.catalog.utils.TableSchemaHelper;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;

public class PulsarAdminTool
implements AutoCloseable {
    private static final String SYSTEM_TOPIC_PREFIX = "__";
    private final PulsarAdmin admin;

    public PulsarAdminTool(PulsarCatalogConfiguration catalogConfiguration) {
        this.admin = PulsarClientFactory.createAdmin(catalogConfiguration);
    }

    @Override
    public void close() {
        this.admin.close();
    }

    public void createTenant(String tenant) throws PulsarAdminException {
        HashSet clusters = new HashSet(this.admin.clusters().getClusters());
        this.admin.tenants().createTenant(tenant, (TenantInfo)TenantInfoImpl.builder().allowedClusters(clusters).build());
    }

    public boolean tenantExists(String tenant) throws PulsarAdminException {
        try {
            this.admin.tenants().getTenantInfo(tenant);
        }
        catch (PulsarAdminException.NotFoundException e) {
            return false;
        }
        return true;
    }

    public List<String> listNamespaces() throws PulsarAdminException {
        List tenants = this.admin.tenants().getTenants();
        ArrayList<String> namespaces = new ArrayList<String>();
        for (String tenant : tenants) {
            namespaces.addAll(this.admin.namespaces().getNamespaces(tenant));
        }
        return namespaces;
    }

    public boolean namespaceExists(String ns) throws PulsarAdminException {
        try {
            this.admin.namespaces().getTopics(ns);
        }
        catch (PulsarAdminException.NotFoundException e) {
            return false;
        }
        return true;
    }

    public void createNamespace(String ns) throws PulsarAdminException {
        this.createNamespace(ns, false);
    }

    public void createNamespace(String ns, boolean retain) throws PulsarAdminException {
        String nsName = NamespaceName.get((String)ns).toString();
        this.admin.namespaces().createNamespace(nsName);
        if (retain) {
            this.admin.namespaces().setRetention(nsName, new RetentionPolicies(-1, -1));
        }
    }

    public void updateNamespaceProperties(String ns, Map<String, String> properties) throws PulsarAdminException {
        this.admin.namespaces().setProperties(ns, properties);
    }

    public Map<String, String> getNamespaceProperties(String ns) throws PulsarAdminException {
        return this.admin.namespaces().getProperties(ns);
    }

    public void deleteNamespace(String ns) throws PulsarAdminException {
        String nsName = NamespaceName.get((String)ns).toString();
        this.admin.namespaces().deleteNamespace(nsName);
    }

    public List<String> getTopics(String ns) throws PulsarAdminException {
        List<String> nonPartitionedTopics = this.getNonPartitionedTopics(ns);
        List partitionedTopics = this.admin.topics().getPartitionedTopicList(ns);
        ArrayList allTopics = new ArrayList();
        Stream.of(partitionedTopics, nonPartitionedTopics).forEach(allTopics::addAll);
        return allTopics.stream().map(t -> TopicName.get((String)t).getLocalName()).filter(topic -> !topic.startsWith(SYSTEM_TOPIC_PREFIX)).collect(Collectors.toList());
    }

    public boolean topicExists(String topicName) throws PulsarAdminException {
        try {
            PartitionedTopicMetadata partitionedTopicMetadata = this.admin.topics().getPartitionedTopicMetadata(topicName);
            if (partitionedTopicMetadata.partitions > 0) {
                return true;
            }
        }
        catch (PulsarAdminException.NotFoundException e) {
            return false;
        }
        return false;
    }

    public void deleteTopic(String topicName) throws PulsarAdminException {
        try {
            this.admin.topics().deletePartitionedTopic(topicName, true);
        }
        catch (PulsarAdminException.NotFoundException e) {
            this.admin.topics().delete(topicName, true);
        }
    }

    public void createTopic(String topicName, int partitionNum) throws PulsarAdminException, IncompatibleSchemaException {
        if (partitionNum > 0) {
            this.admin.topics().createPartitionedTopic(topicName, partitionNum);
        } else {
            this.admin.topics().createNonPartitionedTopic(topicName);
        }
    }

    public void uploadSchema(String topicName, SchemaInfo schemaInfo) throws IncompatibleSchemaException {
        TableSchemaHelper.uploadPulsarSchema(this.admin, topicName, schemaInfo);
    }

    public void deleteSchema(String topicName) {
        TableSchemaHelper.deletePulsarSchema(this.admin, topicName);
    }

    public SchemaInfo getPulsarSchema(String topic) {
        try {
            return this.admin.schemas().getSchemaInfo(TopicName.get((String)topic).toString());
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 404) {
                return BytesSchema.of().getSchemaInfo();
            }
            throw new IllegalStateException(String.format("Failed to get schema information for %s", TopicName.get((String)topic).toString()), e);
        }
        catch (Throwable e) {
            throw new IllegalStateException(String.format("Failed to get schema information for %s", TopicName.get((String)topic).toString()), e);
        }
    }

    private List<String> getNonPartitionedTopics(String namespace) throws PulsarAdminException {
        return this.admin.topics().getList(namespace).stream().filter(t -> !TopicName.get((String)t).isPartitioned()).collect(Collectors.toList());
    }
}

