/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table.catalog;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.connector.pulsar.table.PulsarTableFactory;
import org.apache.flink.connector.pulsar.table.catalog.PulsarCatalogConfiguration;
import org.apache.flink.connector.pulsar.table.catalog.PulsarCatalogFactoryOptions;
import org.apache.flink.connector.pulsar.table.catalog.impl.IncompatibleSchemaException;
import org.apache.flink.connector.pulsar.table.catalog.impl.PulsarCatalogSupport;
import org.apache.flink.connector.pulsar.table.catalog.impl.SchemaTranslator;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarCatalog
extends GenericInMemoryCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarCatalog.class);
    private final PulsarCatalogConfiguration catalogConfiguration;
    private PulsarCatalogSupport catalogSupport;
    private final String flinkTenant;
    public static final String DEFAULT_TENANT = "__flink_catalog";
    public static final String DEFAULT_DB = "default_database";

    public PulsarCatalog(String catalogName, PulsarCatalogConfiguration catalogConfiguration, String database, String flinkTenant) {
        super(catalogName, database);
        this.catalogConfiguration = catalogConfiguration;
        this.flinkTenant = flinkTenant;
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new PulsarTableFactory());
    }

    public void open() throws CatalogException {
        if (this.catalogSupport == null) {
            try {
                this.catalogSupport = new PulsarCatalogSupport(this.catalogConfiguration, this.flinkTenant, new SchemaTranslator(false));
            }
            catch (PulsarAdminException e) {
                throw new CatalogException("Failed to create Pulsar admin with configuration:" + this.catalogConfiguration.toString(), (Throwable)e);
            }
        }
        CatalogDatabaseImpl defaultDatabase = new CatalogDatabaseImpl(new HashMap(), "The default database for PulsarCatalog");
        try {
            this.createDatabase((String)this.catalogConfiguration.get(PulsarCatalogFactoryOptions.DEFAULT_DATABASE), (CatalogDatabase)defaultDatabase, true);
        }
        catch (DatabaseAlreadyExistException e) {
            throw new CatalogException("Error: should ignore default database if not exist instead of throwing exception");
        }
    }

    public void close() throws CatalogException {
        if (this.catalogSupport != null) {
            this.catalogSupport.close();
            this.catalogSupport = null;
            LOG.info("Closed connection to Pulsar.");
        }
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            return this.catalogSupport.listDatabases();
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to list all databases in catalog: %s", this.getName()), (Throwable)e);
        }
    }

    public CatalogDatabase getDatabase(String databaseName) throws CatalogException {
        try {
            return this.catalogSupport.getDatabase(databaseName);
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to get database info in catalog: %s", this.getName()), (Throwable)e);
        }
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            return this.catalogSupport.databaseExists(databaseName);
        }
        catch (PulsarAdminException e) {
            LOG.warn("Failed to check if database exists, encountered PulsarAdminError", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOG.error("Failed to check if database exists", (Throwable)e);
            return false;
        }
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        try {
            this.catalogSupport.createDatabase(name, database);
        }
        catch (PulsarAdminException.ConflictException e) {
            if (!ignoreIfExists) {
                throw new DatabaseAlreadyExistException(this.getName(), name, (Throwable)e);
            }
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to create database %s", name), (Throwable)e);
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        try {
            if (!this.listTables(name).isEmpty() && !cascade) {
                throw new DatabaseNotEmptyException(this.getName(), name);
            }
            this.catalogSupport.dropDatabase(name);
        }
        catch (PulsarAdminException.NotFoundException e) {
            if (!ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.getName(), name);
            }
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to drop database %s", name), (Throwable)e);
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        try {
            return this.catalogSupport.listTables(databaseName);
        }
        catch (PulsarAdminException.NotFoundException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName, (Throwable)e);
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to list tables in database %s", databaseName), (Throwable)e);
        }
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        if (tablePath.getObjectName().startsWith("_tmp_table_")) {
            return super.getTable(tablePath);
        }
        try {
            return this.catalogSupport.getTable(tablePath);
        }
        catch (PulsarAdminException.NotFoundException e) {
            throw new TableNotExistException(this.getName(), tablePath, (Throwable)e);
        }
        catch (IncompatibleSchemaException | PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to get table %s schema", tablePath.getFullName()), e);
        }
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        if (tablePath.getObjectName().startsWith("_tmp_table_")) {
            return super.tableExists(tablePath);
        }
        try {
            return this.catalogSupport.tableExists(tablePath);
        }
        catch (PulsarAdminException.NotFoundException e) {
            return false;
        }
        catch (PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to check table %s existence", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        if (tablePath.getObjectName().startsWith("_tmp_table_")) {
            super.createTable(tablePath, table, ignoreIfExists);
        }
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
        if (this.tableExists(tablePath)) {
            if (!ignoreIfExists) {
                throw new TableAlreadyExistException(this.getName(), tablePath);
            }
            return;
        }
        if (table instanceof ResolvedCatalogTable) {
            try {
                this.catalogSupport.createTable(tablePath, (ResolvedCatalogTable)table);
            }
            catch (IncompatibleSchemaException | PulsarAdminException e) {
                throw new CatalogException(String.format("Failed to create table %s", tablePath.getFullName()), e);
            }
        } else {
            if (table instanceof ResolvedCatalogView) {
                throw new CatalogException(String.format("Can't create view %s with catalog %s", tablePath.getObjectName(), this.getName()));
            }
            throw new CatalogException(String.format("Unknown Table Object kind: %s", table.getClass().getName()));
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            this.catalogSupport.dropTable(tablePath);
        }
        catch (PulsarAdminException.NotFoundException e) {
            if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.getName(), tablePath, (Throwable)e);
            }
            LOG.warn("The table {} does not exist. Drop table operation ignored", (Object)tablePath);
        }
        catch (RuntimeException | PulsarAdminException e) {
            throw new CatalogException(String.format("Failed to drop table %s", tablePath.getFullName()), e);
        }
    }

    public void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> expressions) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }
}

