/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.table;

import java.time.Duration;
import java.util.List;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRoutingMode;
import org.apache.pulsar.client.api.SubscriptionType;

public class PulsarTableOptions {
    public static final ConfigOption<List<String>> TOPICS = ConfigOptions.key((String)"topics").stringType().asList().noDefaultValue().withDescription("Topic names from which the table is read. It is required for both source and sink");
    public static final ConfigOption<SubscriptionType> SOURCE_SUBSCRIPTION_TYPE = ConfigOptions.key((String)"source.subscription-type").enumType(SubscriptionType.class).defaultValue((Object)SubscriptionType.Exclusive).withDescription("Subscription type for Pulsar source to use. Only \"Exclusive\" and \"Shared\" are allowed.");
    public static final ConfigOption<String> SOURCE_SUBSCRIPTION_NAME = ConfigOptions.key((String)"source.subscription-name").stringType().defaultValue((Object)"flink-sql-connector-pulsar").withDescription(Description.builder().text("Specify the subscription name consumer used by runtime PulsarSource.").text(" This argument is required when constructing the consumer.").build());
    public static final ConfigOption<String> SOURCE_START_FROM_MESSAGE_ID = ConfigOptions.key((String)"source.start.message-id").stringType().noDefaultValue().withDescription("Optional message id used to specify a consuming starting point for source. Use \"earliest\", \"latest\" or pass in a message id representation in \"ledgerId:entryId:partitionId\", such as \"12:2:-1\"");
    public static final ConfigOption<Long> SOURCE_START_FROM_PUBLISH_TIME = ConfigOptions.key((String)"source.start.publish-time").longType().noDefaultValue().withDescription("Optional publish timestamp used to specify a consuming starting point for source.");
    public static final ConfigOption<String> SINK_CUSTOM_TOPIC_ROUTER = ConfigOptions.key((String)"sink.custom-topic-router").stringType().noDefaultValue().withDescription("Optional custom TopicRouter implementation class URL to use in sink. If this optionis provided, \"sink.topic-routing-mode\" will be ignored.");
    public static final ConfigOption<TopicRoutingMode> SINK_TOPIC_ROUTING_MODE = ConfigOptions.key((String)"sink.topic-routing-mode").enumType(TopicRoutingMode.class).defaultValue((Object)TopicRoutingMode.ROUND_ROBIN).withDescription("Optional TopicRoutingMode. There are \"round-robin\" and \"message-key-hash\" two options. Default use\"round-robin\", if you want to use a customTopicRouter implementation, use \"sink.custom-topic-router\"");
    public static final ConfigOption<Duration> SINK_MESSAGE_DELAY_INTERVAL = ConfigOptions.key((String)"sink.message-delay-interval").durationType().defaultValue((Object)Duration.ZERO).withDescription("Optional sink message delay delivery interval.");
    public static final ConfigOption<String> KEY_FORMAT = ConfigOptions.key((String)"key.format").stringType().noDefaultValue().withDescription("Defines the format identifier for decoding/encoding key bytes in Pulsar message. The identifier is used to discover a suitable format factory.");
    public static final ConfigOption<List<String>> KEY_FIELDS = ConfigOptions.key((String)"key.fields").stringType().asList().defaultValues((Object[])new String[0]).withDescription("Defines an explicit list of physical columns from the table schema which should be decoded/encoded from the key bytes of a Pulsar message. By default, this list is empty and thus a key is undefined.");
    public static final ConfigOption<String> VALUE_FORMAT = ConfigOptions.key((String)"value.format").stringType().noDefaultValue().withDescription("Defines the format identifier for decoding/encoding value data. The identifier is used to discover a suitable format factory.");
    public static final ConfigOption<String> ADMIN_URL = ConfigOptions.key((String)"admin-url").stringType().noDefaultValue().withDescription(Description.builder().text("The Pulsar service HTTP URL for the admin endpoint. For example, %s, or %s for TLS.", new InlineElement[]{TextElement.code((String)"http://my-broker.example.com:8080"), TextElement.code((String)"https://my-broker.example.com:8443")}).build());
    public static final ConfigOption<String> SERVICE_URL = ConfigOptions.key((String)"service-url").stringType().noDefaultValue().withDescription(Description.builder().text("Service URL provider for Pulsar service.").linebreak().text("To connect to Pulsar using client libraries, you need to specify a Pulsar protocol URL.").linebreak().text("You can assign Pulsar protocol URLs to specific clusters and use the Pulsar scheme.").linebreak().list(new InlineElement[]{TextElement.text((String)"This is an example of %s: %s.", (InlineElement[])new InlineElement[]{TextElement.code((String)"localhost"), TextElement.code((String)"pulsar://localhost:6650")}), TextElement.text((String)"If you have multiple brokers, the URL is as: %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"pulsar://localhost:6550,localhost:6651,localhost:6652")}), TextElement.text((String)"A URL for a production Pulsar cluster is as: %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"pulsar://pulsar.us-west.example.com:6650")}), TextElement.text((String)"If you use TLS authentication, the URL is as %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"pulsar+ssl://pulsar.us-west.example.com:6651")})}).build());
    public static final ConfigOption<Boolean> EXPLICIT = ConfigOptions.key((String)"explicit").booleanType().defaultValue((Object)true).withDescription("Indicate if the table is an explict flink table");

    private PulsarTableOptions() {
    }
}

