/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader.fetcher;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcher;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.connector.pulsar.source.reader.fetcher.PulsarFetcherManagerBase;
import org.apache.flink.connector.pulsar.source.reader.split.PulsarUnorderedPartitionSplitReader;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.pulsar.client.api.Message;

@Internal
public class PulsarUnorderedFetcherManager
extends PulsarFetcherManagerBase {
    public PulsarUnorderedFetcherManager(FutureCompletingBlockingQueue<RecordsWithSplitIds<Message<byte[]>>> elementsQueue, Supplier<SplitReader<Message<byte[]>, PulsarPartitionSplit>> splitReaderSupplier) {
        super(elementsQueue, splitReaderSupplier);
    }

    public List<PulsarPartitionSplit> snapshotState(long checkpointId) {
        return this.fetchers.values().stream().map(SplitFetcher::getSplitReader).map(splitReader -> this.snapshotReader(checkpointId, (SplitReader<Message<byte[]>, PulsarPartitionSplit>)splitReader)).collect(Collectors.toCollection(() -> new ArrayList(this.fetchers.size())));
    }

    private PulsarPartitionSplit snapshotReader(long checkpointId, SplitReader<Message<byte[]>, PulsarPartitionSplit> splitReader) {
        return ((PulsarUnorderedPartitionSplitReader)splitReader).snapshotState(checkpointId).toPulsarPartitionSplit();
    }
}

