/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader.fetcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcher;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcherManager;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.pulsar.client.api.Message;

@Internal
public abstract class PulsarFetcherManagerBase
extends SplitFetcherManager<Message<byte[]>, PulsarPartitionSplit> {
    private final Map<String, Integer> splitFetcherMapping = new HashMap<String, Integer>();
    private final Map<Integer, Boolean> fetcherStatus = new HashMap<Integer, Boolean>();

    protected PulsarFetcherManagerBase(FutureCompletingBlockingQueue<RecordsWithSplitIds<Message<byte[]>>> elementsQueue, Supplier<SplitReader<Message<byte[]>, PulsarPartitionSplit>> splitReaderSupplier) {
        super(elementsQueue, splitReaderSupplier);
    }

    public void addSplits(List<PulsarPartitionSplit> splitsToAdd) {
        for (PulsarPartitionSplit split : splitsToAdd) {
            SplitFetcher<Message<byte[]>, PulsarPartitionSplit> fetcher = this.getOrCreateFetcher(split.splitId());
            fetcher.addSplits(Collections.singletonList(split));
            this.startFetcher(fetcher);
        }
    }

    public void closeFetcher(String splitId) {
        SplitFetcher<Message<byte[]>, PulsarPartitionSplit> fetcher = this.getOrCreateFetcher(splitId);
        fetcher.shutdown();
    }

    protected void startFetcher(SplitFetcher<Message<byte[]>, PulsarPartitionSplit> fetcher) {
        if (this.fetcherStatus.get(fetcher.fetcherId()) != Boolean.TRUE) {
            this.fetcherStatus.put(fetcher.fetcherId(), true);
            super.startFetcher(fetcher);
        }
    }

    protected SplitFetcher<Message<byte[]>, PulsarPartitionSplit> getOrCreateFetcher(String splitId) {
        SplitFetcher fetcher;
        Integer fetcherId = this.splitFetcherMapping.get(splitId);
        if (fetcherId == null) {
            fetcher = this.createSplitFetcher();
        } else {
            fetcher = (SplitFetcher)this.fetchers.get(fetcherId);
            if (fetcher == null) {
                this.fetcherStatus.remove(fetcherId);
                fetcher = this.createSplitFetcher();
            }
        }
        this.splitFetcherMapping.put(splitId, fetcher.fetcherId());
        return fetcher;
    }
}

