/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader.deserializer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchema;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaUtils;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;

@Internal
class PulsarSchemaWrapper<T>
implements PulsarDeserializationSchema<T> {
    private static final long serialVersionUID = -4864701207257059158L;
    private final PulsarSchema<T> pulsarSchema;
    private boolean isSchemaEvolutionEnabled;

    public PulsarSchemaWrapper(PulsarSchema<T> pulsarSchema) {
        this.pulsarSchema = pulsarSchema;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context, SourceConfiguration configuration) throws Exception {
        this.isSchemaEvolutionEnabled = configuration.isEnableSchemaEvolution();
    }

    @Override
    public void deserialize(Message<?> message, Collector<T> out) throws Exception {
        if (this.isSchemaEvolutionEnabled) {
            Object value = message.getValue();
            out.collect(value);
        } else {
            Schema<T> schema = this.pulsarSchema.getPulsarSchema();
            byte[] bytes = message.getData();
            Object instance = schema.decode(bytes);
            out.collect(instance);
        }
    }

    public TypeInformation<T> getProducedType() {
        SchemaInfo info = this.pulsarSchema.getSchemaInfo();
        return PulsarSchemaUtils.createTypeInformation(info);
    }

    @Override
    public Schema<?> schema() {
        if (this.isSchemaEvolutionEnabled) {
            return this.pulsarSchema.getPulsarSchema();
        }
        return Schema.BYTES;
    }
}

