/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader.deserializer;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchema;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchemaWrapper;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarSchemaWrapper;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarTypeInformationWrapper;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.KeyValue;

@PublicEvolving
public interface PulsarDeserializationSchema<T>
extends Serializable,
ResultTypeQueryable<T> {
    default public void open(DeserializationSchema.InitializationContext context, SourceConfiguration configuration) throws Exception {
        this.open(context);
    }

    @Deprecated
    default public void open(DeserializationSchema.InitializationContext context) throws Exception {
    }

    public void deserialize(Message<?> var1, Collector<T> var2) throws Exception;

    default public Schema<?> schema() {
        return Schema.BYTES;
    }

    public static <T> PulsarDeserializationSchema<T> flinkSchema(DeserializationSchema<T> deserializationSchema) {
        return new PulsarDeserializationSchemaWrapper<T>(deserializationSchema);
    }

    public static <T> PulsarDeserializationSchema<T> pulsarSchema(Schema<T> schema) {
        PulsarSchema<T> pulsarSchema = new PulsarSchema<T>(schema);
        return new PulsarSchemaWrapper<T>(pulsarSchema);
    }

    public static <T> PulsarDeserializationSchema<T> pulsarSchema(Schema<T> schema, Class<T> typeClass) {
        PulsarSchema<T> pulsarSchema = new PulsarSchema<T>(schema, typeClass);
        return new PulsarSchemaWrapper<T>(pulsarSchema);
    }

    public static <K, V> PulsarDeserializationSchema<KeyValue<K, V>> pulsarSchema(Schema<KeyValue<K, V>> schema, Class<K> keyClass, Class<V> valueClass) {
        PulsarSchema pulsarSchema = new PulsarSchema(schema, keyClass, valueClass);
        return new PulsarSchemaWrapper<KeyValue<K, V>>(pulsarSchema);
    }

    public static <T> PulsarDeserializationSchema<T> flinkTypeInfo(TypeInformation<T> information, ExecutionConfig config) {
        return new PulsarTypeInformationWrapper<T>(information, config);
    }
}

