/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic.range;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;

public class UniformRangeGenerator
implements RangeGenerator {
    private static final long serialVersionUID = -7292650922683609268L;

    @Override
    public List<TopicRange> range(TopicMetadata metadata, int parallelism) {
        ArrayList<TopicRange> results = new ArrayList<TopicRange>(parallelism);
        int startRange = 0;
        for (int i = 1; i < parallelism; ++i) {
            int nextStartRange = i * 65536 / parallelism;
            results.add(new TopicRange(startRange, nextStartRange - 1));
            startRange = nextStartRange;
        }
        results.add(new TopicRange(startRange, 65535));
        return results;
    }
}

