/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Range;

@PublicEvolving
public class TopicPartition
implements Serializable {
    private static final long serialVersionUID = -1474354741550810953L;
    public static final int NON_PARTITION_ID = -1;
    private final String topic;
    private final int partitionId;
    private final TopicRange range;

    public TopicPartition(String topic) {
        this(topic, -1);
    }

    public TopicPartition(String topic, int partitionId) {
        this(topic, partitionId, TopicRange.createFullRange());
    }

    public TopicPartition(String topic, int partitionId, TopicRange range) {
        this.topic = TopicNameUtils.topicName((String)Preconditions.checkNotNull((Object)topic));
        this.partitionId = partitionId;
        this.range = (TopicRange)Preconditions.checkNotNull((Object)range);
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public boolean isPartition() {
        return this.partitionId != -1;
    }

    public String getFullTopicName() {
        if (this.isPartition()) {
            return TopicNameUtils.topicNameWithPartition(this.topic, this.partitionId);
        }
        return this.topic;
    }

    public TopicRange getRange() {
        return this.range;
    }

    public Range getPulsarRange() {
        return this.range.toPulsarRange();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartition that = (TopicPartition)o;
        return this.partitionId == that.partitionId && this.topic.equals(that.topic) && this.range.equals(that.range);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partitionId, this.range);
    }

    public String toString() {
        return this.getFullTopicName() + "|" + this.range;
    }
}

