/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.PulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;

public abstract class BasePulsarSubscriber
implements PulsarSubscriber {
    private static final long serialVersionUID = 2053021503331058888L;

    protected TopicMetadata queryTopicMetadata(PulsarAdmin pulsarAdmin, String topicName) {
        String completeTopicName = TopicNameUtils.topicName(topicName);
        try {
            PartitionedTopicMetadata metadata = pulsarAdmin.topics().getPartitionedTopicMetadata(completeTopicName);
            return new TopicMetadata(topicName, metadata.partitions);
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw new IllegalStateException(e);
        }
    }

    protected List<TopicPartition> toTopicPartitions(TopicMetadata metadata, List<TopicRange> ranges) {
        if (!metadata.isPartitioned()) {
            return ranges.stream().map(range -> new TopicPartition(metadata.getName(), -1, (TopicRange)range)).collect(Collectors.toList());
        }
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (int i = 0; i < metadata.getPartitionSize(); ++i) {
            for (TopicRange range2 : ranges) {
                TopicPartition partition = new TopicPartition(metadata.getName(), i, range2);
                partitions.add(partition);
            }
        }
        return partitions;
    }
}

