/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor.start;

import java.util.Objects;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.CursorPosition;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StartCursor;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.internal.DefaultImplementation;

public class MessageIdStartCursor
implements StartCursor {
    private static final long serialVersionUID = -8057345435887170111L;
    private final MessageId messageId;

    public MessageIdStartCursor(MessageId messageId, boolean inclusive) {
        MessageIdImpl id = MessageIdImpl.convertToMessageIdImpl((MessageId)messageId);
        Preconditions.checkState((!(id instanceof BatchMessageIdImpl) ? 1 : 0) != 0, (Object)"We only support normal message id currently.");
        this.messageId = MessageId.earliest.equals(id) || MessageId.latest.equals(id) || inclusive ? id : MessageIdStartCursor.getNext(id);
    }

    public static MessageId getNext(MessageIdImpl messageId) {
        if (messageId.getEntryId() < 0L) {
            return DefaultImplementation.getDefaultImplementation().newMessageId(messageId.getLedgerId(), 0L, messageId.getPartitionIndex());
        }
        return DefaultImplementation.getDefaultImplementation().newMessageId(messageId.getLedgerId(), messageId.getEntryId() + 1L, messageId.getPartitionIndex());
    }

    @Override
    public CursorPosition position(String topic, int partitionId) {
        return new CursorPosition(this.messageId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageIdStartCursor that = (MessageIdStartCursor)o;
        return Objects.equals(this.messageId, that.messageId);
    }

    public int hashCode() {
        return Objects.hash(this.messageId);
    }
}

