/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.CursorPosition;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.start.MessageIdStartCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.start.PublishTimestampStartCursor;
import org.apache.pulsar.client.api.MessageId;

@FunctionalInterface
@PublicEvolving
public interface StartCursor
extends Serializable {
    public CursorPosition position(String var1, int var2);

    public static StartCursor defaultStartCursor() {
        return StartCursor.earliest();
    }

    public static StartCursor earliest() {
        return StartCursor.fromMessageId(MessageId.earliest);
    }

    public static StartCursor latest() {
        return StartCursor.fromMessageId(MessageId.latest);
    }

    public static StartCursor fromMessageId(MessageId messageId) {
        return StartCursor.fromMessageId(messageId, true);
    }

    public static StartCursor fromMessageId(MessageId messageId, boolean inclusive) {
        return new MessageIdStartCursor(messageId, inclusive);
    }

    public static StartCursor fromPublishTime(long timestamp) {
        return new PublishTimestampStartCursor(timestamp);
    }
}

