/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.config;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigValidator;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.source.PulsarSourceOptions;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;

@Internal
public final class PulsarSourceConfigUtils {
    public static final PulsarConfigValidator SOURCE_CONFIG_VALIDATOR = PulsarConfigValidator.builder().requiredOption(PulsarOptions.PULSAR_SERVICE_URL).requiredOption(PulsarOptions.PULSAR_ADMIN_URL).requiredOption(PulsarSourceOptions.PULSAR_SUBSCRIPTION_NAME).conflictOptions(PulsarOptions.PULSAR_AUTH_PARAMS, PulsarOptions.PULSAR_AUTH_PARAM_MAP).build();

    private PulsarSourceConfigUtils() {
    }

    public static <T> ConsumerBuilder<T> createConsumerBuilder(PulsarClient client, Schema<T> schema, SourceConfiguration configuration) {
        ConsumerBuilder builder = client.newConsumer(schema);
        configuration.useOption(PulsarSourceOptions.PULSAR_SUBSCRIPTION_NAME, arg_0 -> ((ConsumerBuilder)builder).subscriptionName(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_ACK_TIMEOUT_MILLIS, v -> builder.ackTimeout(v.longValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarSourceOptions.PULSAR_ACK_RECEIPT_ENABLED, arg_0 -> ((ConsumerBuilder)builder).isAckReceiptEnabled(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_TICK_DURATION_MILLIS, v -> builder.ackTimeoutTickTime(v.longValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarSourceOptions.PULSAR_NEGATIVE_ACK_REDELIVERY_DELAY_MICROS, v -> builder.negativeAckRedeliveryDelay(v.longValue(), TimeUnit.MICROSECONDS));
        configuration.useOption(PulsarSourceOptions.PULSAR_SUBSCRIPTION_TYPE, arg_0 -> ((ConsumerBuilder)builder).subscriptionType(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_SUBSCRIPTION_MODE, arg_0 -> ((ConsumerBuilder)builder).subscriptionMode(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_CRYPTO_FAILURE_ACTION, arg_0 -> ((ConsumerBuilder)builder).cryptoFailureAction(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_RECEIVER_QUEUE_SIZE, arg_0 -> ((ConsumerBuilder)builder).receiverQueueSize(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_ACKNOWLEDGEMENTS_GROUP_TIME_MICROS, v -> builder.acknowledgmentGroupTime(v.longValue(), TimeUnit.MICROSECONDS));
        configuration.useOption(PulsarSourceOptions.PULSAR_REPLICATE_SUBSCRIPTION_STATE, arg_0 -> ((ConsumerBuilder)builder).replicateSubscriptionState(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_MAX_TOTAL_RECEIVER_QUEUE_SIZE_ACROSS_PARTITIONS, arg_0 -> ((ConsumerBuilder)builder).maxTotalReceiverQueueSizeAcrossPartitions(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_CONSUMER_NAME, arg_0 -> ((ConsumerBuilder)builder).consumerName(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_READ_COMPACTED, arg_0 -> ((ConsumerBuilder)builder).readCompacted(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_PRIORITY_LEVEL, arg_0 -> ((ConsumerBuilder)builder).priorityLevel(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_SUBSCRIPTION_INITIAL_POSITION, arg_0 -> ((ConsumerBuilder)builder).subscriptionInitialPosition(arg_0));
        PulsarSourceConfigUtils.createDeadLetterPolicy(configuration).ifPresent(arg_0 -> ((ConsumerBuilder)builder).deadLetterPolicy(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_AUTO_UPDATE_PARTITIONS_INTERVAL_SECONDS, v -> builder.autoUpdatePartitionsInterval(v.intValue(), TimeUnit.SECONDS));
        configuration.useOption(PulsarSourceOptions.PULSAR_RETRY_ENABLE, arg_0 -> ((ConsumerBuilder)builder).enableRetry(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_MAX_PENDING_CHUNKED_MESSAGE, arg_0 -> ((ConsumerBuilder)builder).maxPendingChunkedMessage(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_AUTO_ACK_OLDEST_CHUNKED_MESSAGE_ON_QUEUE_FULL, arg_0 -> ((ConsumerBuilder)builder).autoAckOldestChunkedMessageOnQueueFull(arg_0));
        configuration.useOption(PulsarSourceOptions.PULSAR_EXPIRE_TIME_OF_INCOMPLETE_CHUNKED_MESSAGE_MILLIS, v -> builder.expireTimeOfIncompleteChunkedMessage(v.longValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarSourceOptions.PULSAR_POOL_MESSAGES, arg_0 -> ((ConsumerBuilder)builder).poolMessages(arg_0));
        Map<String, String> properties = configuration.getProperties(PulsarSourceOptions.PULSAR_CONSUMER_PROPERTIES);
        if (!properties.isEmpty()) {
            builder.properties(properties);
        }
        return builder;
    }

    private static Optional<DeadLetterPolicy> createDeadLetterPolicy(SourceConfiguration configuration) {
        if (configuration.contains(PulsarSourceOptions.PULSAR_MAX_REDELIVER_COUNT) || configuration.contains(PulsarSourceOptions.PULSAR_RETRY_LETTER_TOPIC) || configuration.contains(PulsarSourceOptions.PULSAR_DEAD_LETTER_TOPIC)) {
            DeadLetterPolicy.DeadLetterPolicyBuilder builder = DeadLetterPolicy.builder();
            configuration.useOption(PulsarSourceOptions.PULSAR_MAX_REDELIVER_COUNT, arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).maxRedeliverCount(arg_0));
            configuration.useOption(PulsarSourceOptions.PULSAR_RETRY_LETTER_TOPIC, arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).retryLetterTopic(arg_0));
            configuration.useOption(PulsarSourceOptions.PULSAR_DEAD_LETTER_TOPIC, arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).deadLetterTopic(arg_0));
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }
}

